/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.XComponentContext;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.support.ConnectionEvent;
import org.aoju.bus.office.support.ConnectionListener;

public class Connection
implements Context {
    private static AtomicInteger bridgeIndex = new AtomicInteger();
    private final UnoUrl unoUrl;
    private final List<ConnectionListener> connectionEventListeners = new ArrayList<ConnectionListener>();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private XComponent bridgeComponent;
    private XMultiComponentFactory serviceManager;
    private XComponentContext componentContext;
    private volatile boolean connected = false;
    private XEventListener bridgeListener = new XEventListener(){

        public void disposing(EventObject event) {
            if (Connection.this.connected) {
                Connection.this.connected = false;
                Connection.this.logger.info(String.format("disconnected: '%s'", Connection.this.unoUrl));
                ConnectionEvent connectionEvent = new ConnectionEvent(Connection.this);
                for (ConnectionListener listener : Connection.this.connectionEventListeners) {
                    listener.disconnected(connectionEvent);
                }
            }
        }
    };

    public Connection(UnoUrl unoUrl) {
        this.unoUrl = unoUrl;
    }

    public void addConnectionEventListener(ConnectionListener connectionEventListener) {
        this.connectionEventListeners.add(connectionEventListener);
    }

    public void connect() throws ConnectException {
        this.logger.fine(String.format("connecting with connectString '%s'", this.unoUrl));
        try {
            XComponentContext localContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory localServiceManager = localContext.getServiceManager();
            XConnector connector = Builder.cast(XConnector.class, localServiceManager.createInstanceWithContext("com.sun.star.connection.Connector", localContext));
            XConnection connection = connector.connect(this.unoUrl.getConnectString());
            XBridgeFactory bridgeFactory = Builder.cast(XBridgeFactory.class, localServiceManager.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", localContext));
            String bridgeName = "jodconverter_" + bridgeIndex.getAndIncrement();
            XBridge bridge = bridgeFactory.createBridge(bridgeName, "urp", connection, null);
            this.bridgeComponent = Builder.cast(XComponent.class, bridge);
            this.bridgeComponent.addEventListener(this.bridgeListener);
            this.serviceManager = Builder.cast(XMultiComponentFactory.class, bridge.getInstance("StarOffice.ServiceManager"));
            XPropertySet properties = Builder.cast(XPropertySet.class, this.serviceManager);
            this.componentContext = Builder.cast(XComponentContext.class, properties.getPropertyValue("DefaultContext"));
            this.connected = true;
            this.logger.info(String.format("connected: '%s'", this.unoUrl));
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            for (ConnectionListener listener : this.connectionEventListeners) {
                listener.connected(connectionEvent);
            }
        }
        catch (NoConnectException connectException) {
            throw new ConnectException(String.format("connection failed: '%s'; %s", this.unoUrl, connectException.getMessage()));
        }
        catch (Exception exception) {
            throw new InstrumentException("connection failed: " + this.unoUrl, exception);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void disconnect() {
        this.logger.fine(String.format("disconnecting: '%s'", this.unoUrl));
        this.bridgeComponent.dispose();
    }

    @Override
    public Object getService(String serviceName) {
        try {
            return this.serviceManager.createInstanceWithContext(serviceName, this.componentContext);
        }
        catch (Exception exception) {
            throw new InstrumentException(String.format("failed to obtain service '%s'", serviceName), exception);
        }
    }
}

