/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support;

import java.net.ConnectException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Manager;
import org.aoju.bus.office.Office;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.support.Connection;

class ExternalManager
implements Manager {
    private final Connection connection;
    private final boolean connectOnStart;

    public ExternalManager(UnoUrl unoUrl, boolean connectOnStart) {
        this.connection = new Connection(unoUrl);
        this.connectOnStart = connectOnStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws InstrumentException {
        if (this.connectOnStart) {
            Connection connection = this.connection;
            synchronized (connection) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Connection connection = this.connection;
        synchronized (connection) {
            if (this.connection.isConnected()) {
                this.connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Office task) throws InstrumentException {
        Connection connection = this.connection;
        synchronized (connection) {
            if (!this.connection.isConnected()) {
                this.connect();
            }
            task.execute(this.connection);
        }
    }

    private void connect() {
        try {
            this.connection.connect();
        }
        catch (ConnectException connectException) {
            throw new InstrumentException("could not connect to external office process", connectException);
        }
    }

    @Override
    public boolean isRunning() {
        return this.connection.isConnected();
    }
}

