/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support;

import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import java.net.ConnectException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Process;
import org.aoju.bus.office.Retryable;
import org.aoju.bus.office.support.Connection;
import org.aoju.bus.office.support.ManagedSettings;
import org.aoju.bus.office.support.NamedThreadFactory;

class ManagedProcess {
    private static final Integer EXIT_CODE_NEW_INSTALLATION = 81;
    private final ManagedSettings settings;
    private final Process process;
    private final Connection connection;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("OfficeProcessThread"));

    public ManagedProcess(ManagedSettings settings) throws InstrumentException {
        this.settings = settings;
        this.process = new Process(settings.getOfficeHome(), settings.getUnoUrl(), settings.getRunAsArgs(), settings.getTemplateProfileDir(), settings.getWorkDir(), settings.getProcessManager());
        this.connection = new Connection(settings.getUnoUrl());
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void startAndWait() throws InstrumentException {
        Future<?> future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ManagedProcess.this.doStartProcessAndConnect();
            }
        });
        try {
            future.get();
        }
        catch (Exception exception) {
            throw new InstrumentException("failed to start and connect", exception);
        }
    }

    public void stopAndWait() throws InstrumentException {
        Future<?> future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ManagedProcess.this.doStopProcess();
            }
        });
        try {
            future.get();
        }
        catch (Exception exception) {
            throw new InstrumentException("failed to start and connect", exception);
        }
    }

    public void restartAndWait() {
        Future<?> future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ManagedProcess.this.doStopProcess();
                ManagedProcess.this.doStartProcessAndConnect();
            }
        });
        try {
            future.get();
        }
        catch (Exception exception) {
            throw new InstrumentException("failed to restart", exception);
        }
    }

    public void restartDueToTaskTimeout() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ManagedProcess.this.doTerminateProcess();
            }
        });
    }

    public void restartDueToLostConnection() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ManagedProcess.this.doEnsureProcessExited();
                    ManagedProcess.this.doStartProcessAndConnect();
                }
                catch (InstrumentException officeException) {
                    ManagedProcess.this.logger.log(Level.SEVERE, "could not restart process", officeException);
                }
            }
        });
    }

    private void doStartProcessAndConnect() throws InstrumentException {
        try {
            this.process.start();
            new Retryable(){

                @Override
                protected void attempt() throws Exception {
                    try {
                        ManagedProcess.this.connection.connect();
                    }
                    catch (ConnectException connectException) {
                        Integer exitCode = ManagedProcess.this.process.getExitCode();
                        if (exitCode == null) {
                            throw new InstrumentException(connectException);
                        }
                        if (exitCode.equals(EXIT_CODE_NEW_INSTALLATION)) {
                            ManagedProcess.this.logger.log(Level.WARNING, "office process died with exit code 81; restarting it");
                            ManagedProcess.this.process.start(true);
                            throw new InstrumentException(connectException);
                        }
                        throw new InstrumentException("office process died with exit code " + exitCode);
                    }
                }
            }.execute(this.settings.getRetryInterval(), this.settings.getRetryTimeout());
        }
        catch (Exception exception) {
            throw new InstrumentException("could not establish connection", exception);
        }
    }

    private void doStopProcess() {
        try {
            XDesktop desktop = Builder.cast(XDesktop.class, this.connection.getService("com.sun.star.frame.Desktop"));
            desktop.terminate();
        }
        catch (DisposedException desktop) {
        }
        catch (Exception exception) {
            this.doTerminateProcess();
        }
        this.doEnsureProcessExited();
    }

    private void doEnsureProcessExited() throws InstrumentException {
        try {
            int exitCode = this.process.getExitCode(this.settings.getRetryInterval(), this.settings.getRetryTimeout());
            this.logger.info("process exited with code " + exitCode);
        }
        catch (InstrumentException ex) {
            this.doTerminateProcess();
        }
        this.process.deleteProfileDir();
    }

    private void doTerminateProcess() throws InstrumentException {
        try {
            int exitCode = this.process.forciblyTerminate(this.settings.getRetryInterval(), this.settings.getRetryTimeout());
            this.logger.info("process forcibly terminated with code " + exitCode);
        }
        catch (Exception exception) {
            throw new InstrumentException("could not terminate process", exception);
        }
    }

    boolean isConnected() {
        return this.connection.isConnected();
    }
}

