/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Manager;
import org.aoju.bus.office.Office;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.support.ConnectionEvent;
import org.aoju.bus.office.support.ConnectionListener;
import org.aoju.bus.office.support.ManagedProcess;
import org.aoju.bus.office.support.NamedThreadFactory;
import org.aoju.bus.office.support.PooledSettings;
import org.aoju.bus.office.support.SuspendableExecutor;

class PooledManager
implements Manager {
    private final PooledSettings settings;
    private final ManagedProcess managedOfficeProcess;
    private final SuspendableExecutor taskExecutor;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private volatile boolean stopping = false;
    private int taskCount;
    private Future<?> currentTask;
    private ConnectionListener connectionEventListener = new ConnectionListener(){

        @Override
        public void connected(ConnectionEvent event) {
            PooledManager.this.taskCount = 0;
            PooledManager.this.taskExecutor.setAvailable(true);
        }

        @Override
        public void disconnected(ConnectionEvent event) {
            PooledManager.this.taskExecutor.setAvailable(false);
            if (PooledManager.this.stopping) {
                PooledManager.this.stopping = false;
            } else {
                PooledManager.this.logger.warning("connection lost unexpectedly; attempting restart");
                if (PooledManager.this.currentTask != null) {
                    PooledManager.this.currentTask.cancel(true);
                }
                PooledManager.this.managedOfficeProcess.restartDueToLostConnection();
            }
        }
    };

    public PooledManager(UnoUrl unoUrl) {
        this(new PooledSettings(unoUrl));
    }

    public PooledManager(PooledSettings settings) {
        this.settings = settings;
        this.managedOfficeProcess = new ManagedProcess(settings);
        this.managedOfficeProcess.getConnection().addConnectionEventListener(this.connectionEventListener);
        this.taskExecutor = new SuspendableExecutor(new NamedThreadFactory("OfficeTaskThread"));
    }

    @Override
    public void execute(final Office task) throws InstrumentException {
        Future<?> futureTask = this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (PooledManager.this.settings.getMaxTasksPerProcess() > 0 && ++PooledManager.this.taskCount == PooledManager.this.settings.getMaxTasksPerProcess() + 1) {
                    PooledManager.this.logger.info(String.format("reached limit of %d maxTasksPerProcess: restarting", PooledManager.this.settings.getMaxTasksPerProcess()));
                    PooledManager.this.taskExecutor.setAvailable(false);
                    PooledManager.this.stopping = true;
                    PooledManager.this.managedOfficeProcess.restartAndWait();
                }
                task.execute(PooledManager.this.managedOfficeProcess.getConnection());
            }
        });
        this.currentTask = futureTask;
        try {
            futureTask.get(this.settings.getTaskExecutionTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            this.managedOfficeProcess.restartDueToTaskTimeout();
            throw new InstrumentException("task did not complete within timeout", timeoutException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof InstrumentException) {
                throw (InstrumentException)executionException.getCause();
            }
            throw new InstrumentException("task failed", executionException.getCause());
        }
        catch (Exception exception) {
            throw new InstrumentException("task failed", exception);
        }
    }

    @Override
    public void start() throws InstrumentException {
        this.managedOfficeProcess.startAndWait();
    }

    @Override
    public void stop() throws InstrumentException {
        this.taskExecutor.setAvailable(false);
        this.stopping = true;
        this.taskExecutor.shutdownNow();
        this.managedOfficeProcess.stopAndWait();
    }

    @Override
    public boolean isRunning() {
        return this.managedOfficeProcess.isConnected();
    }
}

