/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aoju.bus.cache.annotation.CacheKey;
import org.aoju.bus.cache.entity.CacheHolder;

public class PatternGenerator {
    private static final ConcurrentMap<Method, String> patterns = new ConcurrentHashMap<Method, String>();

    public static String generatePattern(CacheHolder cacheHolder) {
        return patterns.computeIfAbsent(cacheHolder.getMethod(), method -> PatternGenerator.doPatternCombiner(cacheHolder));
    }

    private static String doPatternCombiner(CacheHolder cacheHolder) {
        StringBuilder sb = new StringBuilder(cacheHolder.getPrefix());
        Collection<CacheKey> cacheKeys = cacheHolder.getCacheKeyMap().values();
        for (CacheKey cacheKey : cacheKeys) {
            sb.append(cacheKey.value());
        }
        return sb.toString();
    }
}

