/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.utils.MapUtils;

public class MediaType {
    public static final String CHARSET_PARAMETER = "charset";
    public static final String MEDIA_TYPE_WILDCARD = "*";
    public static final String WILDCARD = "*/*";
    public static final MediaType WILDCARD_TYPE = new MediaType();
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType APPLICATION_XML_TYPE = new MediaType("application", "xml");
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType APPLICATION_ATOM_XML_TYPE = new MediaType("application", "atom+xml");
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final MediaType APPLICATION_XHTML_XML_TYPE = new MediaType("application", "xhtml+xml");
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final MediaType APPLICATION_SVG_XML_TYPE = new MediaType("application", "svg+xml");
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType APPLICATION_JSON_TYPE = new MediaType("application", "json");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_FORM_URLENCODED_TYPE = new MediaType("application", "x-www-form-urlencoded");
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType APPLICATION_OCTET_STREAM_TYPE = new MediaType("application", "octet-stream");
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType TEXT_PLAIN_TYPE = new MediaType("text", "plain");
    public static final String TEXT_XML = "text/xml";
    public static final MediaType TEXT_XML_TYPE = new MediaType("text", "xml");
    public static final String TEXT_HTML = "text/html";
    public static final MediaType TEXT_HTML_TYPE = new MediaType("text", "html");
    public static final String APPLICATION_DICOM = "application/dicom";
    public static final MediaType APPLICATION_DICOM_TYPE = new MediaType("application", "dicom");
    public static final String APPLICATION_DICOM_XML = "application/dicom+xml";
    public static final MediaType APPLICATION_DICOM_XML_TYPE = new MediaType("application", "dicom+xml");
    public static final String APPLICATION_DICOM_JSON = "application/dicom+json";
    public static final MediaType APPLICATION_DICOM_JSON_TYPE = new MediaType("application", "dicom+json");
    public static final String IMAGE_WILDCARD = "image/*";
    public static final MediaType IMAGE_WILDCARD_TYPE = new MediaType("image", "*");
    public static final String IMAGE_GIF = "image/gif";
    public static final MediaType IMAGE_GIF_TYPE = new MediaType("image", "gif");
    public static final String IMAGE_PNG = "image/png";
    public static final MediaType IMAGE_PNG_TYPE = new MediaType("image", "png");
    public static final String IMAGE_BMP = "image/bmp";
    public static final MediaType IMAGE_BMP_TYPE = new MediaType("image", "bmp");
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final MediaType IMAGE_JPEG_TYPE = new MediaType("image", "jpeg");
    public static final String IMAGE_X_JLS = "image/x-jls";
    public static final MediaType IMAGE_X_JLS_TYPE = new MediaType("image", "x-jls");
    public static final String IMAGE_JP2 = "image/jp2";
    public static final MediaType IMAGE_JP2_TYPE = new MediaType("image", "jp2");
    public static final String IMAGE_JPX = "image/jpx";
    public static final MediaType IMAGE_JPX_TYPE = new MediaType("image", "jpx");
    public static final String IMAGE_X_DICOM_RLE = "image/x-dicom+rle";
    public static final MediaType IMAGE_X_DICOM_RLE_TYPE = new MediaType("image", "x-dicom+rle");
    public static final String VIDEO_WILDCARD = "video/*";
    public static final MediaType VIDEO_WILDCARD_TYPE = new MediaType("video", "*");
    public static final String VIDEO_MPEG = "video/mpeg";
    public static final MediaType VIDEO_MPEG_TYPE = new MediaType("video", "mpeg");
    public static final String VIDEO_MP4 = "video/mp4";
    public static final MediaType VIDEO_MP4_TYPE = new MediaType("video", "mp4");
    public static final String APPLICATION_PDF = "application/pdf";
    public static final MediaType APPLICATION_PDF_TYPE = new MediaType("application", "pdf");
    public static final String TEXT_RTF = "text/rtf";
    public static final MediaType TEXT_RTF_TYPE = new MediaType("text", "rtf");
    public static final String TEXT_CSV = "text/csv";
    public static final MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
    public static final String TEXT_CSV_UTF8 = "text/csv;charset=utf-8";
    public static final MediaType TEXT_CSV_UTF8_TYPE = new MediaType("text", "csv", "utf-8");
    public static final String APPLICATION_ZIP = "application/zip";
    public static final MediaType APPLICATION_ZIP_TYPE = new MediaType("application", "zip");
    public static final String APPLICATION_ZIP_COMPRESSED = "application/x-zip-compressed";
    public static final MediaType APPLICATION_ZIP_COMPRESSED_TYPE = new MediaType("application", "x-zip-compressed");
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE = new MediaType("multipart", "form-data");
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final MediaType MULTIPART_MIXED_TYPE = new MediaType("multipart", "mixed");
    public static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static final MediaType MULTIPART_ALTERNATIVE_TYPE = new MediaType("multipart", "alternative");
    public static final String MULTIPART_DIGEST = "multipart/digest";
    public static final MediaType MULTIPART_DIGEST_TYPE = new MediaType("multipart", "digest");
    public static final String MULTIPART_parallel = "multipart/parallel";
    public static final MediaType MULTIPART_PARALLEL_TYPE = new MediaType("multipart", "parallel");
    public static final String MULTIPART_RELATED = "multipart/related";
    public static final MediaType MULTIPART_RELATED_TYPE = new MediaType("multipart", "related");
    public static final MediaType MULTIPART_RELATED_APPLICATION_DICOM_TYPE = new MediaType("multipart", "related", Collections.singletonMap("type", "application/dicom"));
    public static final MediaType MULTIPART_RELATED_APPLICATION_DICOM_XML_TYPE = new MediaType("multipart", "related", Collections.singletonMap("type", "application/dicom+xml"));
    public static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    public static final String QUOTED = "\"([^\"]*)\"";
    public static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    public static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    public final String type;
    public final String subtype;
    public final String charset;
    public final String mediaType;
    public Map<String, String> parameters;

    public MediaType() {
        this(null, MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD, null, null);
    }

    public MediaType(String mediaType) {
        this(mediaType, MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD, null, null);
    }

    public MediaType(String type, String subtype) {
        this(null, type, subtype, null, null);
    }

    public MediaType(String type, String subtype, String charset) {
        this(null, type, subtype, charset, null);
    }

    public MediaType(String mediaType, String type, String subtype, String charset) {
        this(mediaType, type, subtype, charset, null);
    }

    public MediaType(String type, String subtype, Map<String, String> params) {
        this(null, type, subtype, null, MediaType.createParametersMap(params));
    }

    public MediaType(String type, String subtype, String charset, Map<String, String> params) {
        this(null, type, subtype, charset, MediaType.createParametersMap(params));
    }

    public MediaType(String mediaType, String type, String subtype, String charset, Map<String, String> params) {
        this.mediaType = mediaType == null ? APPLICATION_FORM_URLENCODED : mediaType;
        this.type = type == null ? MEDIA_TYPE_WILDCARD : type;
        this.subtype = subtype == null ? MEDIA_TYPE_WILDCARD : subtype;
        String string = this.charset = charset == null ? "UTF-8" : charset;
        if (MapUtils.isNotEmpty(params)) {
            params = new TreeMap(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
        }
        AbstractMap abstractMap = params = params == null ? new HashMap() : params;
        if (charset != null && !charset.isEmpty()) {
            params.put(CHARSET_PARAMETER, charset);
        }
        this.parameters = Collections.unmodifiableMap(params);
    }

    public static MediaType valueOf(String text) {
        Matcher typeSubtype = TYPE_SUBTYPE.matcher(text);
        if (!typeSubtype.lookingAt()) {
            throw new IllegalArgumentException("No subtype found for: \"" + text + '\"');
        }
        String type = typeSubtype.group(1).toLowerCase(Locale.US);
        String subtype = typeSubtype.group(2).toLowerCase(Locale.US);
        String charset = null;
        Matcher parameter = PARAMETER.matcher(text);
        int s = typeSubtype.end();
        while (s < text.length()) {
            parameter.region(s, text.length());
            if (!parameter.lookingAt()) {
                throw new IllegalArgumentException("Parameter is not formatted correctly: " + text.substring(s) + " for:" + text);
            }
            String name = parameter.group(1);
            if (name != null && name.equalsIgnoreCase(CHARSET_PARAMETER)) {
                String token = parameter.group(2);
                String charsetParameter = token != null ? (token.startsWith("'") && token.endsWith("'") && token.length() > 2 ? token.substring(1, token.length() - 1) : token) : parameter.group(3);
                if (charset != null && !charsetParameter.equalsIgnoreCase(charset)) {
                    throw new IllegalArgumentException("Multiple charsets defined: " + charset + " and: " + charsetParameter + " for: " + text);
                }
                charset = charsetParameter;
            }
            s = parameter.end();
        }
        return new MediaType(text, type, subtype, charset);
    }

    private static TreeMap<String, String> createParametersMap(Map<String, String> initialValues) {
        TreeMap<String, String> map = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        if (initialValues != null) {
            for (Map.Entry<String, String> e : initialValues.entrySet()) {
                map.put(e.getKey().toLowerCase(), e.getValue());
            }
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode() + this.parameters.hashCode();
    }

    public String toString() {
        return this.mediaType;
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public Charset charset() {
        return this.charset(null);
    }

    public Charset charset(Charset defaultValue) {
        try {
            return this.charset != null ? Charset.forName(this.charset) : defaultValue;
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public boolean isCompatible(MediaType mediaType) {
        return mediaType != null && (this.type.equals(MEDIA_TYPE_WILDCARD) || mediaType.type.equals(MEDIA_TYPE_WILDCARD) || this.type.equalsIgnoreCase(mediaType.type) && (this.subtype.equals(MEDIA_TYPE_WILDCARD) || mediaType.subtype.equals(MEDIA_TYPE_WILDCARD)) || this.type.equalsIgnoreCase(mediaType.type) && this.subtype.equalsIgnoreCase(mediaType.subtype));
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

