/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.CharsetUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IterUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.UriUtils;

public class Scaner {
    private String packageName;
    private String packageNameWithDot;
    private String packageDirName;
    private String packagePath;
    private Filter<Class<?>> classFilter;
    private java.nio.charset.Charset charset;
    private boolean initialize;
    private Set<Class<?>> classes = new HashSet();

    public Scaner() {
        this(null);
    }

    public Scaner(String packageName) {
        this(packageName, null);
    }

    public Scaner(String packageName, Filter<Class<?>> classFilter) {
        this(packageName, classFilter, Charset.UTF_8);
    }

    public Scaner(String packageName, Filter<Class<?>> classFilter, java.nio.charset.Charset charset) {
        this.packageName = packageName = StringUtils.nullToEmpty(packageName);
        this.packageNameWithDot = StringUtils.addSuffixIfNot(packageName, ".");
        this.packageDirName = packageName.replace('.', File.separatorChar);
        this.packagePath = packageName.replace('.', '/');
        this.classFilter = classFilter;
        this.charset = charset;
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, final Class<? extends Annotation> annotationClass) {
        return Scaner.scanPackage(packageName, new Filter<Class<?>>(){

            @Override
            public boolean accept(Class<?> clazz) {
                return clazz.isAnnotationPresent(annotationClass);
            }
        });
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, final Class<?> superClass) {
        return Scaner.scanPackage(packageName, new Filter<Class<?>>(){

            @Override
            public boolean accept(Class<?> clazz) {
                return superClass.isAssignableFrom(clazz) && !superClass.equals(clazz);
            }
        });
    }

    public static Set<Class<?>> scanPackage() {
        return Scaner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return Scaner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        return new Scaner(packageName, classFilter).scan();
    }

    public Set<Class<?>> scan() {
        for (URL url : ResourceUtils.getResourceIter(this.packagePath)) {
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(UriUtils.decode(url.getFile(), this.charset.name())), null);
                    break;
                }
                case "jar": {
                    this.scanJar(UriUtils.getJarFile(url));
                }
            }
        }
        if (CollUtils.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    private void scanJavaClassPaths() {
        String[] javaClassPaths;
        for (String classPath : javaClassPaths = ClassUtils.getJavaClassPaths()) {
            classPath = UriUtils.decode(classPath, CharsetUtils.systemCharsetName());
            this.scanFile(new File(classPath), null);
        }
    }

    private void scanFile(File file, String rootDir) {
        if (file.isFile()) {
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(".class")) {
                String className = fileName.substring(rootDir.length(), fileName.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(className);
            } else if (fileName.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException e) {
                    throw new InstrumentException(e);
                }
            }
        } else if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    private void scanJar(JarFile jar) {
        for (JarEntry entry : new IterUtils.EnumerationIter<JarEntry>(jar.entries())) {
            String name = StringUtils.removePrefix(entry.getName(), "/");
            if (!name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            this.addIfAccept(this.loadClass(className));
        }
    }

    private Class<?> loadClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, this.initialize, ClassUtils.getClassLoader());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clazz;
    }

    private void addIfAccept(String className) {
        int packageLen;
        if (StringUtils.isBlank(className)) {
            return;
        }
        int classLen = className.length();
        if (classLen == (packageLen = this.packageName.length())) {
            if (className.equals(this.packageName)) {
                this.addIfAccept(this.loadClass(className));
            }
        } else if (classLen > packageLen && className.startsWith(this.packageNameWithDot)) {
            this.addIfAccept(this.loadClass(className));
        }
    }

    private void addIfAccept(Class<?> clazz) {
        Filter<Class<?>> classFilter;
        if (null != clazz && ((classFilter = this.classFilter) == null || classFilter.accept(clazz))) {
            this.classes.add(clazz);
        }
    }

    private String subPathBeforePackage(File file) {
        String filePath = file.getAbsolutePath();
        if (StringUtils.isNotEmpty(this.packageDirName)) {
            filePath = StringUtils.subBefore((CharSequence)filePath, this.packageDirName, true);
        }
        return StringUtils.addSuffixIfNot(filePath, File.separator);
    }
}

