/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.awt.Color;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.utils.StringUtils;

public class HexUtils {
    public static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    public static char[] encodeHex(byte[] data) {
        return HexUtils.encodeHex(data, true);
    }

    public static char[] encodeHex(String str, java.nio.charset.Charset charset) {
        return HexUtils.encodeHex(StringUtils.bytes((CharSequence)str, charset), true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHex(data, toLowerCase ? Normal.DIGITS_LOWER : Normal.DIGITS_UPPER);
    }

    public static String encodeHexStr(byte[] data) {
        return HexUtils.encodeHexStr(data, true);
    }

    public static String encodeHexStr(String data, java.nio.charset.Charset charset) {
        return HexUtils.encodeHexStr(StringUtils.bytes((CharSequence)data, charset), true);
    }

    public static String encodeHexStr(String data) {
        return HexUtils.encodeHexStr(data, Charset.UTF_8);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHexStr(data, toLowerCase ? Normal.DIGITS_LOWER : Normal.DIGITS_UPPER);
    }

    public static String decodeHexStr(String hexStr) {
        return HexUtils.decodeHexStr(hexStr, Charset.UTF_8);
    }

    public static String decodeHexStr(String hexStr, java.nio.charset.Charset charset) {
        if (StringUtils.isEmpty(hexStr)) {
            return hexStr;
        }
        return HexUtils.decodeHexStr(hexStr.toCharArray(), charset);
    }

    public static String decodeHexStr(char[] hexData, java.nio.charset.Charset charset) {
        return StringUtils.str(HexUtils.decodeHex(hexData), charset);
    }

    public static byte[] decodeHex(char[] hexData) {
        int len = hexData.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtils.toDigit(hexData[j], j) << 4;
            f |= HexUtils.toDigit(hexData[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static byte[] decodeHex(String hexStr) {
        if (StringUtils.isEmpty(hexStr)) {
            return null;
        }
        return HexUtils.decodeHex(hexStr.toCharArray());
    }

    public static String encodeColor(Color color) {
        return HexUtils.encodeColor(color, "#");
    }

    public static String encodeColor(Color color, String prefix) {
        StringBuffer builder = new StringBuffer(prefix);
        String colorHex = Integer.toHexString(color.getRed());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getGreen());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getBlue());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        return builder.toString();
    }

    public static Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    public static String toUnicodeHex(int value) {
        StringBuilder builder = new StringBuilder(6);
        builder.append("\\u");
        String hex = Integer.toHexString(value);
        int len = hex.length();
        if (len < 4) {
            builder.append("0000", 0, 4 - len);
        }
        builder.append(hex);
        return builder.toString();
    }

    public static String toUnicodeHex(char ch) {
        StringBuilder sb = new StringBuilder(6);
        sb.append("\\u");
        sb.append(Normal.DIGITS_LOWER[ch >> 12 & 0xF]);
        sb.append(Normal.DIGITS_LOWER[ch >> 8 & 0xF]);
        sb.append(Normal.DIGITS_LOWER[ch >> 4 & 0xF]);
        sb.append(Normal.DIGITS_LOWER[ch & 0xF]);
        return sb.toString();
    }

    private static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(HexUtils.encodeHex(data, toDigits));
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

