/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.utils.ThreadUtils;
import org.aoju.bus.cron.Scheduler;

public class CronTimer
extends Thread {
    private long TIMER_UNIT_SECOND = Fields.Unit.SECOND.getMillis();
    private long TIMER_UNIT_MINUTE = Fields.Unit.MINUTE.getMillis();
    private boolean isStoped;
    private Scheduler scheduler;

    public CronTimer(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        long nextTime;
        long sleep;
        long timerUnit = this.scheduler.matchSecond ? this.TIMER_UNIT_SECOND : this.TIMER_UNIT_MINUTE;
        long thisTime = System.currentTimeMillis();
        while (!this.isStoped && ((sleep = (nextTime = (thisTime / timerUnit + 1L) * timerUnit) - System.currentTimeMillis()) <= 0L || ThreadUtils.safeSleep(sleep))) {
            thisTime = System.currentTimeMillis();
            this.spawnLauncher(thisTime);
        }
    }

    public synchronized void stopTimer() {
        this.isStoped = true;
        ThreadUtils.interupt(this, true);
    }

    private void spawnLauncher(long millis) {
        this.scheduler.launcherManager.spawnLauncher(millis);
    }
}

