/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.freebsd;

import java.util.function.Supplier;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.common.unix.freebsd.BsdSysctlUtils;
import org.aoju.bus.health.hardware.AbstractGlobalMemory;
import org.aoju.bus.health.hardware.VirtualMemory;
import org.aoju.bus.health.hardware.unix.freebsd.FreeBsdVirtualMemory;

public class FreeBsdGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Long> total = Memoizer.memoize(this::queryPhysMem);
    private final Supplier<Long> pageSize = Memoizer.memoize(this::queryPageSize);
    private final Supplier<Long> available = Memoizer.memoize(this::queryVmStats, Memoizer.defaultExpiration());
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    @Override
    public long getAvailable() {
        return this.available.get();
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private long queryVmStats() {
        long inactive = BsdSysctlUtils.sysctl("vm.stats.vm.v_inactive_count", 0L);
        long cache = BsdSysctlUtils.sysctl("vm.stats.vm.v_cache_count", 0L);
        long free = BsdSysctlUtils.sysctl("vm.stats.vm.v_free_count", 0L);
        return (inactive + cache + free) * this.getPageSize();
    }

    private long queryPhysMem() {
        return BsdSysctlUtils.sysctl("hw.physmem", 0L);
    }

    private long queryPageSize() {
        return BsdSysctlUtils.sysctl("hw.pagesize", 4096L);
    }

    private VirtualMemory createVirtualMemory() {
        return new FreeBsdVirtualMemory();
    }
}

