/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.solaris;

import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.hardware.AbstractVirtualMemory;

public class SolarisVirtualMemory
extends AbstractVirtualMemory {
    private static final Pattern SWAP_INFO = Pattern.compile(".+\\s(\\d+)K\\s+(\\d+)K$");
    private final Supplier<SwapInfo> swapInfo = Memoizer.memoize(this::querySwapInfo, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesIn = Memoizer.memoize(this::queryPagesIn, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesOut = Memoizer.memoize(this::queryPagesOut, Memoizer.defaultExpiration());

    @Override
    public long getSwapUsed() {
        return this.swapInfo.get().used;
    }

    @Override
    public long getSwapTotal() {
        return this.swapInfo.get().total;
    }

    @Override
    public long getSwapPagesIn() {
        return this.pagesIn.get();
    }

    @Override
    public long getSwapPagesOut() {
        return this.pagesOut.get();
    }

    private long queryPagesIn() {
        long swapPagesIn = 0L;
        for (String s : Command.runNative("kstat -p cpu_stat:::pgpgin")) {
            swapPagesIn += Builder.parseLastLong(s, 0L);
        }
        return swapPagesIn;
    }

    private long queryPagesOut() {
        long swapPagesOut = 0L;
        for (String s : Command.runNative("kstat -p cpu_stat:::pgpgout")) {
            swapPagesOut += Builder.parseLastLong(s, 0L);
        }
        return swapPagesOut;
    }

    private SwapInfo querySwapInfo() {
        long swapTotal = 0L;
        long swapUsed = 0L;
        String swap = Command.getAnswerAt("swap -lk", 1);
        Matcher m = SWAP_INFO.matcher(swap);
        if (m.matches()) {
            swapTotal = Builder.parseLongOrDefault(m.group(1), 0L) << 10;
            swapUsed = swapTotal - (Builder.parseLongOrDefault(m.group(2), 0L) << 10);
        }
        return new SwapInfo(swapTotal, swapUsed);
    }

    private static final class SwapInfo {
        private final long total;
        private final long used;

        private SwapInfo(long total, long used) {
            this.total = total;
            this.used = used;
        }
    }
}

