/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class DouyinProvider
extends DefaultProvider {
    public DouyinProvider(Context context) {
        super(context, Registry.DOUYIN);
    }

    public DouyinProvider(Context context, StateCache stateCache) {
        super(context, Registry.DOUYIN, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return this.getToken(this.accessTokenUrl(Callback2.getCode()));
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("union_id")).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("avatar")).remark(object.getString("description")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken oldToken) {
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(oldToken.getRefreshToken()))).build();
    }

    private void checkResponse(JSONObject object) {
        String message = object.getString("message");
        JSONObject data = object.getJSONObject("data");
        int errorCode = data.getIntValue("error_code");
        if ("error".equals(message) || errorCode != 0) {
            throw new InstrumentException("" + errorCode, data.getString("description"));
        }
    }

    private AccToken getToken(String accessTokenUrl) {
        JSONObject object = JSONObject.parseObject((String)HttpClient.post(accessTokenUrl));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).openId(object.getString("open_id")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).scope(object.getString("scope")).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_key", this.context.getClientId()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "user_info").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_key", this.context.getClientId()).queryParam("client_secret", this.context.getClientSecret()).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("open_id", token.getOpenId()).build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromBaseUrl(this.source.refresh()).queryParam("client_key", this.context.getClientId()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").build();
    }
}

