/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class FacebookProvider
extends DefaultProvider {
    public FacebookProvider(Context context) {
        super(context, Registry.FACEBOOK);
    }

    public FacebookProvider(Context context, StateCache stateCache) {
        super(context, Registry.FACEBOOK, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(Callback2.getCode()));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).tokenType(object.getString("token_type")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("id")).username(object.getString("name")).nickname(object.getString("name")).avatar(this.getUserPicture(object)).location(object.getString("locale")).email(object.getString("email")).gender(Normal.Gender.getGender(object.getString("gender"))).token(token).source(this.source.toString()).build();
    }

    private String getUserPicture(JSONObject object) {
        String picture = null;
        if (object.containsKey((Object)"picture")) {
            JSONObject pictureObj = object.getJSONObject("picture");
            if (null != (pictureObj = pictureObj.getJSONObject("data"))) {
                picture = pictureObj.getString("url");
            }
        }
        return picture;
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("fields", "id,name,birthday,gender,hometown,email,devices,picture.width(400)").build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getJSONObject("error").getString("message"));
        }
    }
}

