/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class GitlabProvider
extends DefaultProvider {
    public GitlabProvider(Context context) {
        super(context, Registry.GITLAB);
    }

    public GitlabProvider(Context context, StateCache stateCache) {
        super(context, Registry.GITLAB, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(Callback2.getCode()));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).idToken(object.getString("id_token")).tokenType(object.getString("token_type")).scope(object.getString("scope")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("id")).username(object.getString("username")).nickname(object.getString("name")).avatar(object.getString("avatar_url")).blog(object.getString("web_url")).company(object.getString("organization")).location(object.getString("location")).email(object.getString("email")).remark(object.getString("bio")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getString("error_description"));
        }
        if (object.containsKey((Object)"message")) {
            throw new InstrumentException(object.getString("message"));
        }
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(super.authorize(state)).queryParam("scope", "read_user+openid+profile+email").build();
    }
}

