/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.nio.channels.CompletionHandler;
import java.util.concurrent.Semaphore;
import org.aoju.bus.core.io.segment.RingBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.NetMonitor;
import org.aoju.bus.socket.origin.StateMachine;
import org.aoju.bus.socket.origin.TcpAioSession;
import org.aoju.bus.socket.origin.TcpReadEvent;

class TcpReadHandler<T>
implements CompletionHandler<Integer, TcpAioSession<T>> {
    private Semaphore semaphore;
    private ThreadLocal<CompletionHandler> recursionThreadLocal = null;
    private RingBuffer<TcpReadEvent> ringBuffer;

    public TcpReadHandler() {
    }

    public TcpReadHandler(final RingBuffer<TcpReadEvent> ringBuffer, ThreadLocal<CompletionHandler> recursionThreadLocal, Semaphore semaphore) {
        this.semaphore = semaphore;
        this.recursionThreadLocal = recursionThreadLocal;
        this.ringBuffer = ringBuffer;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            int consumerIndex = ringBuffer.nextReadIndex();
                            TcpReadEvent readEvent = (TcpReadEvent)ringBuffer.get(consumerIndex);
                            TcpAioSession aioSession = readEvent.getSession();
                            int size = readEvent.getReadSize();
                            ringBuffer.publishReadIndex(consumerIndex);
                            TcpReadHandler.this.completed0(size, aioSession);
                        }
                    }
                    catch (InterruptedException e) {
                        Logger.error("", e);
                        continue;
                    }
                    break;
                }
            }
        }, "bus-socket:DaemonThread");
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
    }

    @Override
    public void completed(Integer result, TcpAioSession<T> aioSession) {
        if (this.recursionThreadLocal == null || this.recursionThreadLocal.get() != null) {
            this.completed0(result, aioSession);
            return;
        }
        if (this.semaphore.tryAcquire()) {
            try {
                this.recursionThreadLocal.set(this);
                this.completed0(result, aioSession);
                this.runRingBufferTask();
            }
            finally {
                this.recursionThreadLocal.remove();
                this.semaphore.release();
            }
        }
        try {
            int sequence = this.ringBuffer.nextWriteIndex();
            TcpReadEvent readEvent = this.ringBuffer.get(sequence);
            readEvent.setSession(aioSession);
            readEvent.setReadSize(result);
            this.ringBuffer.publishWriteIndex(sequence);
        }
        catch (InterruptedException e) {
            Logger.error("InterruptedException", e);
        }
    }

    void runRingBufferTask() {
        int index;
        if (this.ringBuffer == null) {
            return;
        }
        while ((index = this.ringBuffer.tryNextReadIndex()) >= 0) {
            TcpReadEvent readEvent = this.ringBuffer.get(index);
            TcpAioSession aioSession = readEvent.getSession();
            int size = readEvent.getReadSize();
            this.ringBuffer.publishReadIndex(index);
            this.completed0(size, aioSession);
        }
    }

    private void completed0(Integer result, TcpAioSession<T> aioSession) {
        try {
            NetMonitor<T> monitor = aioSession.getServerConfig().getMonitor();
            if (monitor != null) {
                monitor.readMonitor(aioSession, result);
            }
            aioSession.readFromChannel(result == -1);
        }
        catch (Exception e) {
            this.failed((Throwable)e, aioSession);
        }
    }

    @Override
    public void failed(Throwable exc, TcpAioSession<T> aioSession) {
        try {
            aioSession.getServerConfig().getProcessor().stateEvent(aioSession, StateMachine.INPUT_EXCEPTION, exc);
        }
        catch (Exception e) {
            Logger.debug(e.getMessage(), e);
        }
        try {
            aioSession.close(false);
        }
        catch (Exception e) {
            Logger.debug(e.getMessage(), e);
        }
    }
}

