/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.preview;

import java.util.stream.Stream;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Provider;
import org.aoju.bus.office.bridge.LocalOfficePoolManager;
import org.aoju.bus.office.bridge.OnlineOfficePoolManager;
import org.aoju.bus.office.magic.family.FormatRegistry;
import org.aoju.bus.office.magic.family.RegistryInstanceHolder;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.process.ProcessManager;
import org.aoju.bus.office.provider.LocalOfficeProvider;
import org.aoju.bus.office.provider.OnlineOfficeProvider;
import org.aoju.bus.starter.preview.PreviewProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={LocalOfficeProvider.class, OnlineOfficeProvider.class})
@EnableConfigurationProperties(value={PreviewProperties.class})
public class PreviewConfiguration {
    @Autowired
    PreviewProperties properties;

    @Bean(name={"localOfficeManager"}, initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"localOfficeManager"})
    public OfficeManager localOfficeManager(ProcessManager processManager) {
        LocalOfficePoolManager.Builder builder = LocalOfficePoolManager.builder();
        if (!StringUtils.isBlank(this.properties.getPortNumbers())) {
            builder.portNumbers(ArrayUtils.toPrimitive((Integer[])Stream.of(StringUtils.split((CharSequence)this.properties.getPortNumbers(), ",")).map(str -> NumberUtils.toInt(str, 8102)).toArray(Integer[]::new)));
        }
        builder.officeHome(this.properties.getOfficeHome());
        builder.workingDir(this.properties.getWorkingDir());
        builder.templateProfileDir(this.properties.getTemplateProfileDir());
        builder.killExistingProcess(this.properties.isKillExistingProcess());
        builder.processTimeout(this.properties.getProcessTimeout());
        builder.processRetryInterval(this.properties.getProcessRetryInterval());
        builder.taskExecutionTimeout(this.properties.getTaskExecutionTimeout());
        builder.maxTasksPerProcess(this.properties.getMaxTasksPerProcess());
        builder.taskQueueTimeout(this.properties.getTaskQueueTimeout());
        String processManagerClass = this.properties.getProcessManagerClass();
        if (StringUtils.isNotEmpty(processManagerClass)) {
            builder.processManager(processManagerClass);
        } else {
            builder.processManager(processManager);
        }
        return builder.build();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"onlineOfficeManager"})
    public OfficeManager onlineOfficeManager() {
        OnlineOfficePoolManager.Builder builder = OnlineOfficePoolManager.builder();
        builder.urlConnection(this.properties.getUrl());
        builder.poolSize(this.properties.getPoolSize());
        builder.workingDir(this.properties.getWorkingDir());
        builder.taskExecutionTimeout(this.properties.getTaskExecutionTimeout());
        builder.taskQueueTimeout(this.properties.getTaskQueueTimeout());
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"localDocumentConverter"})
    @ConditionalOnBean(name={"localOfficeManager", "formatRegistry"})
    public Provider localDocumentConverter(OfficeManager localOfficeManager, FormatRegistry formatRegistry) {
        return ((LocalOfficeProvider.Builder)((LocalOfficeProvider.Builder)LocalOfficeProvider.builder().officeManager(localOfficeManager)).formatRegistry(formatRegistry)).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"onlineDocumentConverter"})
    @ConditionalOnBean(name={"onlineOfficeManager"})
    public Provider onlineDocumentConverter(OfficeManager onlineOfficeManager) {
        return OnlineOfficeProvider.make(onlineOfficeManager);
    }

    @Bean
    @ConditionalOnMissingBean(name={"processManager"})
    public ProcessManager processManager() {
        return Builder.findBestProcessManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"documentFormatRegistry"})
    public FormatRegistry documentFormatRegistry() {
        return RegistryInstanceHolder.getInstance();
    }
}

