/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.provider;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.aoju.bus.cache.provider.AbstractProvider;
import org.aoju.bus.core.utils.StringUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class H2Provider
extends AbstractProvider {
    public H2Provider(Map<String, Object> context) {
        super(context);
    }

    public H2Provider(String url, String username, String password) {
        super(url, username, password);
    }

    @Override
    protected Supplier<JdbcOperations> jdbcOperationsSupplier(Map<String, Object> context) {
        return () -> {
            SingleConnectionDataSource dataSource = new SingleConnectionDataSource();
            dataSource.setDriverClassName("org.h2.Driver");
            dataSource.setUrl(StringUtils.toString(context.get("url")));
            dataSource.setUsername(StringUtils.toString(context.get("username")));
            dataSource.setPassword(StringUtils.toString(context.get("password")));
            JdbcTemplate template = new JdbcTemplate((DataSource)dataSource);
            template.execute("CREATE TABLE IF NOT EXISTS hi_cache_rate(id BIGINT     IDENTITY PRIMARY KEY,pattern       VARCHAR(64) NOT NULL UNIQUE,hit_count     BIGINT      NOT NULL     DEFAULT 0,require_count BIGINT      NOT NULL     DEFAULT 0,version       BIGINT      NOT NULL     DEFAULT 0)");
            return template;
        };
    }

    @Override
    protected Stream<AbstractProvider.DataDO> transferResults(List<Map<String, Object>> mapResults) {
        return mapResults.stream().map(map -> {
            AbstractProvider.DataDO dataDO = new AbstractProvider.DataDO();
            dataDO.setPattern((String)map.get("PATTERN"));
            dataDO.setHitCount((Long)map.get("HIT_COUNT"));
            dataDO.setRequireCount((Long)map.get("REQUIRE_COUNT"));
            dataDO.setVersion((Long)map.get("VERSION"));
            return dataDO;
        });
    }

    @Override
    @PreDestroy
    public void tearDown() {
        super.tearDown();
    }
}

