/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.software.unix.freebsd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.common.unix.freebsd.BsdSysctlUtils;
import org.aoju.bus.health.software.FileSystem;
import org.aoju.bus.health.software.OSFileStore;

public class FreeBsdFileSystem
implements FileSystem {
    private final List<String> pseudofs = Arrays.asList("procfs", "devfs", "ctfs", "fdescfs", "objfs", "mntfs", "sharefs", "lofs", "autofs");
    private final List<String> tmpfsPaths = Arrays.asList("/system", "/tmp", "/dev/fd");

    public static boolean updateFileStoreStats(OSFileStore osFileStore) {
        for (OSFileStore fileStore : new FreeBsdFileSystem().getFileStores()) {
            if (!osFileStore.getName().equals(fileStore.getName()) || !osFileStore.getVolume().equals(fileStore.getVolume()) || !osFileStore.getMount().equals(fileStore.getMount())) continue;
            osFileStore.setLogicalVolume(fileStore.getLogicalVolume());
            osFileStore.setDescription(fileStore.getDescription());
            osFileStore.setType(fileStore.getType());
            osFileStore.setUUID(fileStore.getUUID());
            osFileStore.setFreeSpace(fileStore.getFreeSpace());
            osFileStore.setUsableSpace(fileStore.getUsableSpace());
            osFileStore.setTotalSpace(fileStore.getTotalSpace());
            osFileStore.setFreeInodes(fileStore.getFreeInodes());
            osFileStore.setTotalInodes(fileStore.getTotalInodes());
            return true;
        }
        return false;
    }

    private boolean listElementStartsWith(List<String> aList, String charSeq) {
        for (String match : aList) {
            if (!charSeq.equals(match) && !charSeq.startsWith(match + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public OSFileStore[] getFileStores() {
        String[] split;
        HashMap<String, String> uuidMap = new HashMap<String, String>();
        String device = "";
        for (String line : Command.runNative("geom part list")) {
            if (line.contains("Name: ")) {
                device = line.substring(line.lastIndexOf(32) + 1);
            }
            if (device.isEmpty() || !(line = line.trim()).startsWith("rawuuid:")) continue;
            uuidMap.put(device, line.substring(line.lastIndexOf(32) + 1));
            device = "";
        }
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeTotalMap = new HashMap<String, Long>();
        for (String line : Command.runNative("df -i")) {
            if (!line.startsWith("/") || (split = Builder.whitespaces.split(line)).length <= 7) continue;
            inodeFreeMap.put(split[0], Builder.parseLongOrDefault(split[6], 0L));
            inodeTotalMap.put(split[0], (Long)inodeFreeMap.get(split[0]) + Builder.parseLongOrDefault(split[5], 0L));
        }
        for (String fs : Command.runNative("mount -p")) {
            split = Builder.whitespaces.split(fs);
            if (split.length < 5) continue;
            String volume = split[0];
            String path = split[1];
            String type = split[2];
            if (this.pseudofs.contains(type) || path.equals("/dev") || this.listElementStartsWith(this.tmpfsPaths, path) || volume.startsWith("rpool") && !path.equals("/")) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            File f = new File(path);
            long totalSpace = f.getTotalSpace();
            long usableSpace = f.getUsableSpace();
            long freeSpace = f.getFreeSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (type.startsWith("nfs") || type.equals("cifs") ? "Network Disk" : "Mount Point"));
            String uuid = uuidMap.getOrDefault(name, "");
            OSFileStore osStore = new OSFileStore();
            osStore.setName(name);
            osStore.setVolume(volume);
            osStore.setMount(path);
            osStore.setDescription(description);
            osStore.setType(type);
            osStore.setUUID(uuid);
            osStore.setFreeSpace(freeSpace);
            osStore.setUsableSpace(usableSpace);
            osStore.setTotalSpace(totalSpace);
            osStore.setFreeInodes(inodeFreeMap.containsKey(path) ? (Long)inodeFreeMap.get(path) : 0L);
            osStore.setTotalInodes(inodeTotalMap.containsKey(path) ? (Long)inodeTotalMap.get(path) : 0L);
            fsList.add(osStore);
        }
        return fsList.toArray(new OSFileStore[0]);
    }

    @Override
    public long getOpenFileDescriptors() {
        return BsdSysctlUtils.sysctl("kern.openfiles", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return BsdSysctlUtils.sysctl("kern.maxfiles", 0);
    }
}

