/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.software.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.common.unix.solaris.KstatUtils;
import org.aoju.bus.health.software.FileSystem;
import org.aoju.bus.health.software.OSFileStore;

public class SolarisFileSystem
implements FileSystem {
    private final List<String> pseudofs = Arrays.asList("proc", "devfs", "ctfs", "objfs", "mntfs", "sharefs", "lofs", "autofs");
    private final List<String> tmpfsPaths = Arrays.asList("/system", "/tmp", "/dev/fd");

    public static boolean updateFileStoreStats(OSFileStore osFileStore) {
        for (OSFileStore fileStore : new SolarisFileSystem().getFileStoreMatching(osFileStore.getName())) {
            if (!osFileStore.getVolume().equals(fileStore.getVolume()) || !osFileStore.getMount().equals(fileStore.getMount())) continue;
            osFileStore.setLogicalVolume(fileStore.getLogicalVolume());
            osFileStore.setDescription(fileStore.getDescription());
            osFileStore.setType(fileStore.getType());
            osFileStore.setFreeSpace(fileStore.getFreeSpace());
            osFileStore.setUsableSpace(fileStore.getUsableSpace());
            osFileStore.setTotalSpace(fileStore.getTotalSpace());
            osFileStore.setFreeInodes(fileStore.getFreeInodes());
            osFileStore.setTotalInodes(fileStore.getTotalInodes());
            return true;
        }
        return false;
    }

    private boolean listElementStartsWith(List<String> aList, String charSeq) {
        for (String match : aList) {
            if (!charSeq.equals(match) && !charSeq.startsWith(match + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public OSFileStore[] getFileStores() {
        List<OSFileStore> fsList = this.getFileStoreMatching(null);
        return fsList.toArray(new OSFileStore[0]);
    }

    private List<OSFileStore> getFileStoreMatching(String nameToMatch) {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeTotalMap = new HashMap<String, Long>();
        String key = null;
        String total = null;
        String free = null;
        for (String line : Command.runNative("df -g")) {
            if (line.startsWith("/")) {
                key = Builder.whitespaces.split(line)[0];
                total = null;
                continue;
            }
            if (line.contains("available") && line.contains("total files")) {
                total = Builder.getTextBetweenStrings(line, "available", "total files").trim();
                continue;
            }
            if (!line.contains("free files")) continue;
            free = Builder.getTextBetweenStrings(line, "", "free files").trim();
            if (key == null || total == null) continue;
            inodeFreeMap.put(key, Builder.parseLongOrDefault(free, 0L));
            inodeTotalMap.put(key, Builder.parseLongOrDefault(total, 0L));
            key = null;
        }
        for (String fs : Command.runNative("cat /etc/mnttab")) {
            String[] split = Builder.whitespaces.split(fs);
            if (split.length < 5) continue;
            String volume = split[0];
            String path = split[1];
            String type = split[2];
            if (this.pseudofs.contains(type) || path.equals("/dev") || this.listElementStartsWith(this.tmpfsPaths, path) || volume.startsWith("rpool") && !path.equals("/")) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            if (nameToMatch != null && !nameToMatch.equals(name)) continue;
            File f = new File(path);
            long totalSpace = f.getTotalSpace();
            long usableSpace = f.getUsableSpace();
            long freeSpace = f.getFreeSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (type.startsWith("nfs") || type.equals("cifs") ? "Network Disk" : "Mount Point"));
            OSFileStore osStore = new OSFileStore();
            osStore.setName(name);
            osStore.setVolume(volume);
            osStore.setMount(path);
            osStore.setDescription(description);
            osStore.setType(type);
            osStore.setUUID("");
            osStore.setFreeSpace(freeSpace);
            osStore.setUsableSpace(usableSpace);
            osStore.setTotalSpace(totalSpace);
            osStore.setFreeInodes(inodeFreeMap.containsKey(path) ? (Long)inodeFreeMap.get(path) : 0L);
            osStore.setTotalInodes(inodeTotalMap.containsKey(path) ? (Long)inodeTotalMap.get(path) : 0L);
            fsList.add(osStore);
        }
        return fsList;
    }

    @Override
    public long getOpenFileDescriptors() {
        try (KstatUtils.KstatChain kc = KstatUtils.openChain();){
            LibKstat.Kstat ksp = kc.lookup(null, -1, "file_cache");
            if (ksp != null && kc.read(ksp)) {
                long l = KstatUtils.dataLookupLong(ksp, "buf_inuse");
                return l;
            }
        }
        return 0L;
    }

    @Override
    public long getMaxFileDescriptors() {
        try (KstatUtils.KstatChain kc = KstatUtils.openChain();){
            LibKstat.Kstat ksp = kc.lookup(null, -1, "file_cache");
            if (ksp != null && kc.read(ksp)) {
                long l = KstatUtils.dataLookupLong(ksp, "buf_max");
                return l;
            }
        }
        return 0L;
    }
}

