/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.family;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.office.magic.family.DocumentFormat;
import org.aoju.bus.office.magic.family.FamilyType;
import org.aoju.bus.office.magic.family.FormatRegistry;

public class SimpleFormatRegistry
implements FormatRegistry {
    private final Map<String, DocumentFormat> fmtsByExtension = new HashMap<String, DocumentFormat>();
    private final Map<String, DocumentFormat> fmtsByMediaType = new HashMap<String, DocumentFormat>();

    public void addFormat(DocumentFormat documentFormat) {
        documentFormat.getExtensions().stream().map(StringUtils::lowerCase).forEach(ext -> this.fmtsByExtension.put((String)ext, documentFormat));
        this.fmtsByMediaType.put(StringUtils.lowerCase(documentFormat.getMediaType()), documentFormat);
    }

    @Override
    public DocumentFormat getFormatByExtension(String extension) {
        return extension == null ? null : this.fmtsByExtension.get(StringUtils.lowerCase(extension));
    }

    @Override
    public DocumentFormat getFormatByMediaType(String mediaType) {
        return mediaType == null ? null : this.fmtsByMediaType.get(StringUtils.lowerCase(mediaType));
    }

    @Override
    public Set<DocumentFormat> getOutputFormats(FamilyType family) {
        return Optional.ofNullable(family).map(docFam -> this.fmtsByMediaType.values().stream().filter(format -> format.getStoreProperties((FamilyType)((Object)docFam)) != null).collect(Collectors.toSet())).orElse(new HashSet());
    }
}

