/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.builtin.AbstractJob;
import org.aoju.bus.office.builtin.AbstractNorm;
import org.aoju.bus.office.builtin.LocalMadeInOffice;
import org.aoju.bus.office.magic.family.FormatRegistry;
import org.aoju.bus.office.magic.filter.DefaultFilter;
import org.aoju.bus.office.magic.filter.Filter;
import org.aoju.bus.office.magic.filter.FilterChain;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.provider.AbstractProvider;
import org.aoju.bus.office.provider.AbstractSourceProvider;
import org.aoju.bus.office.provider.AbstractTargetProvider;

public class LocalOfficeProvider
extends AbstractProvider {
    public static final Map<String, Object> DEFAULT_LOAD_PROPERTIES;
    private final Map<String, Object> storeProperties;
    private Map<String, Object> loadProperties;
    private FilterChain filterChain;

    public LocalOfficeProvider(OfficeManager officeManager, FormatRegistry formatRegistry, Map<String, Object> loadProperties, FilterChain filterChain, Map<String, Object> storeProperties) {
        super(officeManager, formatRegistry);
        this.loadProperties = loadProperties;
        this.filterChain = filterChain;
        this.storeProperties = storeProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LocalOfficeProvider make() {
        return LocalOfficeProvider.builder().build();
    }

    public static LocalOfficeProvider make(OfficeManager officeManager) {
        return ((Builder)LocalOfficeProvider.builder().officeManager(officeManager)).build();
    }

    @Override
    protected AbstractNorm convert(AbstractSourceProvider source) {
        return new Local(source);
    }

    LocalOfficeProvider setLoadProperties(Map<String, Object> loadProperties) {
        if (this.loadProperties == null) {
            this.loadProperties = new HashMap<String, Object>();
        }
        this.loadProperties.clear();
        this.loadProperties.putAll(loadProperties);
        return this;
    }

    LocalOfficeProvider setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
        return this;
    }

    static {
        HashMap<String, Comparable<Boolean>> loadProperties = new HashMap<String, Comparable<Boolean>>();
        loadProperties.put("Hidden", Boolean.valueOf(true));
        loadProperties.put("ReadOnly", Boolean.valueOf(true));
        loadProperties.put("UpdateDocMode", Short.valueOf((short)1));
        DEFAULT_LOAD_PROPERTIES = Collections.unmodifiableMap(loadProperties);
    }

    private class LocalJob
    extends AbstractJob {
        private LocalJob(AbstractSourceProvider source, AbstractTargetProvider target) {
            super(source, target);
        }

        @Override
        public void doExecute() throws InstrumentException {
            LocalMadeInOffice task = new LocalMadeInOffice(this.source, this.target, LocalOfficeProvider.this.loadProperties, LocalOfficeProvider.this.filterChain, LocalOfficeProvider.this.storeProperties);
            LocalOfficeProvider.this.officeManager.execute(task);
        }
    }

    private class Local
    extends AbstractNorm {
        private Local(AbstractSourceProvider source) {
            super(source, LocalOfficeProvider.this.officeManager, LocalOfficeProvider.this.formatRegistry);
        }

        @Override
        protected AbstractJob to(AbstractTargetProvider target) {
            return new LocalJob(this.source, target);
        }
    }

    public static final class Builder
    extends AbstractProvider.AbstractConverterBuilder<Builder> {
        private Map<String, Object> loadProperties;
        private FilterChain filterChain;
        private Map<String, Object> storeProperties;

        private Builder() {
        }

        @Override
        public LocalOfficeProvider build() {
            return new LocalOfficeProvider(this.officeManager, this.formatRegistry, this.loadProperties, this.filterChain, this.storeProperties);
        }

        public Builder loadProperties(Map<String, Object> properties) {
            this.loadProperties = properties;
            return this;
        }

        public Builder filterChain(Filter ... filters) {
            this.filterChain = new DefaultFilter(filters);
            return this;
        }

        public Builder filterChain(FilterChain filterChain) {
            this.filterChain = filterChain;
            return this;
        }

        public Builder storeProperties(Map<String, Object> properties) {
            this.storeProperties = properties;
            return this;
        }
    }
}

