/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.io.segment.BufferPage;
import org.aoju.bus.core.io.segment.VirtualBuffer;
import org.aoju.bus.socket.origin.Function;
import org.aoju.bus.socket.origin.ServerConfig;

public class WriteBuffer
extends OutputStream {
    private static final int WRITE_CHUNK_SIZE = ServerConfig.getIntProperty("bus-socket.session.writeChunkSize", 4096);
    private final VirtualBuffer[] items;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();
    private final Condition waiting = this.lock.newCondition();
    private final BufferPage bufferPage;
    private final Function<WriteBuffer, Void> function;
    private volatile boolean isWaiting = false;
    private int takeIndex;
    private int putIndex;
    private int count;
    private VirtualBuffer writeInBuf;
    private boolean closed = false;
    private byte[] cacheByte = new byte[8];

    protected WriteBuffer(BufferPage bufferPage, Function<WriteBuffer, Void> flushFunction, int writeQueueSize) {
        this.bufferPage = bufferPage;
        this.function = flushFunction;
        this.items = new VirtualBuffer[writeQueueSize];
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    public void writeShort(short v) throws IOException {
        this.cacheByte[0] = (byte)(v >>> 8 & 0xFF);
        this.cacheByte[1] = (byte)(v >>> 0 & 0xFF);
        this.write(this.cacheByte, 0, 2);
    }

    public void writeByte(byte b) {
        if (this.writeInBuf == null) {
            this.writeInBuf = this.bufferPage.allocate(WRITE_CHUNK_SIZE);
        }
        this.writeInBuf.buffer().put(b);
        if (this.writeInBuf.buffer().hasRemaining()) {
            return;
        }
        this.writeInBuf.buffer().flip();
        this.lock.lock();
        try {
            this.put(this.writeInBuf);
        }
        finally {
            this.lock.unlock();
        }
        this.writeInBuf = null;
        this.function.apply(this);
    }

    public void writeInt(int v) throws IOException {
        this.cacheByte[0] = (byte)(v >>> 24 & 0xFF);
        this.cacheByte[1] = (byte)(v >>> 16 & 0xFF);
        this.cacheByte[2] = (byte)(v >>> 8 & 0xFF);
        this.cacheByte[3] = (byte)(v >>> 0 & 0xFF);
        this.write(this.cacheByte, 0, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream has closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.lock.lock();
        try {
            this.waitPreWriteFinish();
            do {
                ByteBuffer writeBuffer;
                int minSize;
                if (this.writeInBuf == null) {
                    this.writeInBuf = this.bufferPage.allocate(Math.max(WRITE_CHUNK_SIZE, len - off));
                }
                if ((minSize = Math.min((writeBuffer = this.writeInBuf.buffer()).remaining(), len - off)) == 0 || this.closed) {
                    this.writeInBuf.clean();
                    throw new IOException("writeBuffer.remaining:" + writeBuffer.remaining() + " closed:" + this.closed);
                }
                writeBuffer.put(b, off, minSize);
                off += minSize;
                if (writeBuffer.hasRemaining()) continue;
                writeBuffer.flip();
                VirtualBuffer buffer = this.writeInBuf;
                this.writeInBuf = null;
                this.put(buffer);
                this.function.apply(this);
            } while (off < len);
            this.notifyWaiting();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void notifyWaiting() {
        this.isWaiting = false;
        this.waiting.signal();
    }

    private void waitPreWriteFinish() throws IOException {
        while (this.isWaiting) {
            try {
                this.waiting.await();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    public void writeAndFlush(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        this.writeAndFlush(b, 0, b.length);
    }

    public void writeAndFlush(byte[] b, int off, int len) throws IOException {
        this.write(b, off, len);
        this.flush();
    }

    @Override
    public void flush() {
        if (this.closed) {
            throw new RuntimeException("OutputStream has closed");
        }
        int size = this.count;
        if (size > 0) {
            this.function.apply(this);
        } else if (this.writeInBuf != null && this.writeInBuf.buffer().position() > 0 && this.lock.tryLock()) {
            try {
                if (this.writeInBuf != null && this.writeInBuf.buffer().position() > 0) {
                    VirtualBuffer buffer = this.writeInBuf;
                    this.writeInBuf = null;
                    buffer.buffer().flip();
                    this.put(buffer);
                    ++size;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (size > 0) {
                this.function.apply(this);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            VirtualBuffer byteBuf;
            if (this.closed) {
                throw new IOException("OutputStream has closed");
            }
            this.flush();
            this.closed = true;
            while ((byteBuf = this.poll()) != null) {
                byteBuf.clean();
            }
            if (this.writeInBuf != null) {
                this.writeInBuf.clean();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    boolean hasData() {
        return this.count > 0 || this.writeInBuf != null && this.writeInBuf.buffer().position() > 0;
    }

    private void put(VirtualBuffer virtualBuffer) {
        try {
            while (this.count == this.items.length) {
                this.isWaiting = true;
                this.notFull.await();
            }
            this.items[this.putIndex] = virtualBuffer;
            if (++this.putIndex == this.items.length) {
                this.putIndex = 0;
            }
            ++this.count;
            this.notEmpty.signal();
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
    }

    VirtualBuffer poll() {
        this.lock.lock();
        try {
            if (this.count == 0) {
                VirtualBuffer virtualBuffer = null;
                return virtualBuffer;
            }
            VirtualBuffer x = this.items[this.takeIndex];
            this.items[this.takeIndex] = null;
            if (++this.takeIndex == this.items.length) {
                this.takeIndex = 0;
            }
            --this.count;
            this.notFull.signal();
            VirtualBuffer virtualBuffer = x;
            return virtualBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }
}

