/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.exception.NoSuchException;
import org.aoju.bus.core.lang.exception.ValidateException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.validate.Context;
import org.aoju.bus.validate.Validated;
import org.aoju.bus.validate.annotation.Complex;
import org.aoju.bus.validate.validators.Property;

public class Provider {
    public static <T> T on(Object object) {
        return (T)new Validated(object).access();
    }

    public static <T> T on(Object object, Context context) {
        return (T)new Validated(object, context).access();
    }

    public static <T> T on(Object object, Annotation[] annotations) {
        return (T)new Validated(object, annotations).access();
    }

    public static <T> T on(Object object, Annotation[] annotations, Context context) {
        return (T)new Validated(object, annotations, context).access();
    }

    public static <T> T on(Object object, Annotation[] annotations, Context context, String field) {
        return (T)new Validated(object, annotations, context, field).access();
    }

    public static boolean isAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return annotationType.getAnnotation(Complex.class) != null;
    }

    public static boolean isArray(Object object) {
        return object.getClass().isArray();
    }

    public static boolean isCollection(Object object) {
        return Collection.class.isAssignableFrom(object.getClass());
    }

    public static boolean isMap(Object object) {
        return Map.class.isAssignableFrom(object.getClass());
    }

    public static boolean isGroup(String[] group, List<String> list) {
        if (group == null || group.length == 0) {
            return true;
        }
        if (list == null || list.isEmpty()) {
            return false;
        }
        return Arrays.stream(group).anyMatch(neededGroup -> list.stream().anyMatch(neededGroup::equals));
    }

    public static ValidateException resolve(Property property, Context context) {
        String ecode;
        Class<? extends ValidateException> clazz = context.getException();
        clazz = clazz == null ? property.getException() : clazz;
        String propertyEcode = property.getErrcode();
        String globalEcode = context.getErrcode();
        String string = ecode = "-1".equals(propertyEcode) ? globalEcode : propertyEcode;
        if (ObjectUtils.isEmpty(clazz)) {
            return new ValidateException(ecode, property.getFormatted());
        }
        try {
            Constructor<? extends ValidateException> constructor = clazz.getConstructor(String.class, Integer.TYPE);
            return constructor.newInstance(property.getFormatted(), ecode);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchException("\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49\u6821\u9a8c\u5f02\u5e38, \u6ca1\u6709\u6307\u5b9a\u7684\u6784\u9020\u65b9\u6cd5: constructor(String, int)");
        }
        catch (IllegalAccessException e) {
            throw new NoSuchException("\u65e0\u6cd5\u8bbf\u95ee\u81ea\u5b9a\u4e49\u6821\u9a8c\u5f02\u5e38\u6784\u9020\u65b9\u6cd5");
        }
        catch (InstantiationException e) {
            throw new NoSuchException("\u53cd\u5c04\u6784\u5efa\u81ea\u5b9a\u4e49\u6821\u9a8c\u5f02\u5e38\u5931\u8d25");
        }
        catch (InvocationTargetException e) {
            throw new NoSuchException("\u53cd\u5c04\u6784\u5efa\u81ea\u5b9a\u4e49\u6821\u9a8c\u5f02\u5e38\u5931\u8d25");
        }
    }

    public static List<Annotation> getAnnotation(Class<?> clazz) {
        Annotation[] annotations = clazz.getAnnotations();
        return Arrays.stream(annotations).filter(Provider::isAnnotation).collect(Collectors.toList());
    }
}

