/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Protocol;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.accord.Connection;
import org.aoju.bus.http.metric.Handshake;

public abstract class EventListener {
    public static final EventListener NONE = new EventListener(){};

    public static Factory factory(final EventListener listener) {
        return new Factory(){

            @Override
            public EventListener create(NewCall call) {
                return listener;
            }
        };
    }

    public void callStart(NewCall call) {
    }

    public void dnsStart(NewCall call, String domainName) {
    }

    public void dnsEnd(NewCall call, String domainName, List<InetAddress> inetAddressList) {
    }

    public void connectStart(NewCall call, InetSocketAddress inetSocketAddress, Proxy proxy) {
    }

    public void secureConnectStart(NewCall call) {
    }

    public void secureConnectEnd(NewCall call, Handshake handshake) {
    }

    public void connectEnd(NewCall call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
    }

    public void connectFailed(NewCall call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
    }

    public void connectionAcquired(NewCall call, Connection connection) {
    }

    public void connectionReleased(NewCall call, Connection connection) {
    }

    public void requestHeadersStart(NewCall call) {
    }

    public void requestHeadersEnd(NewCall call, Request request) {
    }

    public void requestBodyStart(NewCall call) {
    }

    public void requestBodyEnd(NewCall call, long byteCount) {
    }

    public void responseHeadersStart(NewCall call) {
    }

    public void responseHeadersEnd(NewCall call, Response response) {
    }

    public void responseBodyStart(NewCall call) {
    }

    public void responseBodyEnd(NewCall call, long byteCount) {
    }

    public void callEnd(NewCall call) {
    }

    public void callFailed(NewCall call, IOException ioe) {
    }

    public static interface Factory {
        public EventListener create(NewCall var1);
    }
}

