/*
 * The MIT License
 *
 * Copyright (c) 2017 aoju.org All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.aoju.bus.forest.provider;

import org.aoju.bus.forest.algorithm.Key;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 包装的加密器
 *
 * @author Kimi Liu
 * @version 5.3.9
 * @since JDK 1.8+
 */
public abstract class WrappedEncryptorProvider implements EncryptorProvider {

    protected final EncryptorProvider encryptorProvider;

    protected WrappedEncryptorProvider(EncryptorProvider encryptorProvider) {
        this.encryptorProvider = encryptorProvider;
    }

    @Override
    public void encrypt(Key key, File src, File dest) throws IOException {
        encryptorProvider.encrypt(key, src, dest);
    }

    @Override
    public void encrypt(Key key, InputStream in, OutputStream out) throws IOException {
        encryptorProvider.encrypt(key, in, out);
    }

    @Override
    public InputStream encrypt(Key key, InputStream in) throws IOException {
        return encryptorProvider.encrypt(key, in);
    }

    @Override
    public OutputStream encrypt(Key key, OutputStream out) throws IOException {
        return encryptorProvider.encrypt(key, out);
    }
}
