/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.segment;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.io.segment.BufferPage;

public class BufferPool {
    private static Timer timer = new Timer("BufferPoolClean", true);
    private BufferPage[] bufferPageList;
    private volatile AtomicInteger cursor = new AtomicInteger(0);

    public BufferPool(int pageSize, int poolSize, boolean isDirect) {
        this.bufferPageList = new BufferPage[poolSize];
        for (int i = 0; i < poolSize; ++i) {
            this.bufferPageList[i] = new BufferPage(pageSize, isDirect);
        }
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (BufferPage bufferPage : BufferPool.this.bufferPageList) {
                    bufferPage.tryClean();
                }
            }
        }, 500L, 1000L);
    }

    public BufferPage allocateBufferPage() {
        return this.bufferPageList[this.cursor.getAndIncrement() % this.bufferPageList.length];
    }
}

