/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.loader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.UriUtils;

public class JarLoaders
extends URLClassLoader {
    public JarLoaders() {
        this(new URL[0]);
    }

    public JarLoaders(URL[] urls) {
        super(urls, ClassUtils.getClassLoader());
    }

    public static JarLoaders load(File dir) {
        JarLoaders loader = new JarLoaders();
        loader.addJar(dir);
        loader.addURL(dir);
        return loader;
    }

    public static JarLoaders loadJar(File jarFile) {
        JarLoaders loader = new JarLoaders();
        try {
            loader.addJar(jarFile);
        }
        finally {
            IoUtils.close(loader);
        }
        return loader;
    }

    public static void loadJar(URLClassLoader loader, File jarFile) throws InstrumentException {
        try {
            Method method = ClassUtils.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                method.setAccessible(true);
                List<File> jars = JarLoaders.loopJar(jarFile);
                for (File jar : jars) {
                    ReflectUtils.invoke((Object)loader, method, jar.toURI().toURL());
                }
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File jarFile) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarLoaders.loadJar(urlClassLoader, jarFile);
        return urlClassLoader;
    }

    private static List<File> loopJar(File file) {
        return FileUtils.loopFiles(file, file1 -> {
            String path = file1.getPath();
            return path != null && path.toLowerCase().endsWith(".jar");
        });
    }

    private static boolean isJarFile(File file) {
        if (!FileUtils.isFile(file)) {
            return false;
        }
        return file.getPath().toLowerCase().endsWith(".jar");
    }

    public JarLoaders addJar(File jarFile) {
        List<File> jars = JarLoaders.loopJar(jarFile);
        try {
            for (File jar : jars) {
                super.addURL(jar.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public JarLoaders addURL(File dir) {
        super.addURL(UriUtils.getURL(dir));
        return this;
    }
}

