/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.builder;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.aoju.bus.mapper.MapperException;
import org.aoju.bus.mapper.annotation.ColumnType;
import org.aoju.bus.mapper.annotation.NameStyle;
import org.aoju.bus.mapper.builder.FieldSourceBuilder;
import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.mapper.criteria.Identity;
import org.aoju.bus.mapper.criteria.SimpleType;
import org.aoju.bus.mapper.criteria.Style;
import org.aoju.bus.mapper.criteria.Words;
import org.aoju.bus.mapper.entity.Config;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.aoju.bus.mapper.entity.EntityField;
import org.aoju.bus.mapper.entity.EntityTable;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.UnknownTypeHandler;

public class EntityBuilder {
    private static final Map<Class<?>, EntityTable> entityTableMap = new ConcurrentHashMap();

    public static EntityTable getEntityTable(Class<?> entityClass) {
        EntityTable entityTable = entityTableMap.get(entityClass);
        if (entityTable == null) {
            throw new MapperException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u5bf9\u5e94\u7684\u8868\u540d!");
        }
        return entityTable;
    }

    public static String getOrderByClause(Class<?> entityClass) {
        EntityTable table = EntityBuilder.getEntityTable(entityClass);
        if (table.getOrderByClause() != null) {
            return table.getOrderByClause();
        }
        StringBuilder orderBy = new StringBuilder();
        for (EntityColumn column : table.getEntityClassColumns()) {
            if (column.getOrderBy() == null) continue;
            if (orderBy.length() != 0) {
                orderBy.append(",");
            }
            orderBy.append(column.getColumn()).append(" ").append(column.getOrderBy());
        }
        table.setOrderByClause(orderBy.toString());
        return table.getOrderByClause();
    }

    public static Set<EntityColumn> getColumns(Class<?> entityClass) {
        return EntityBuilder.getEntityTable(entityClass).getEntityClassColumns();
    }

    public static Set<EntityColumn> getPKColumns(Class<?> entityClass) {
        return EntityBuilder.getEntityTable(entityClass).getEntityClassPKColumns();
    }

    public static String getSelectColumns(Class<?> entityClass) {
        EntityTable entityTable = EntityBuilder.getEntityTable(entityClass);
        if (entityTable.getBaseSelect() != null) {
            return entityTable.getBaseSelect();
        }
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        boolean skipAlias = Map.class.isAssignableFrom(entityClass);
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn());
            if (!skipAlias && !entityColumn.getColumn().equalsIgnoreCase(entityColumn.getProperty())) {
                if (entityColumn.getColumn().substring(1, entityColumn.getColumn().length() - 1).equalsIgnoreCase(entityColumn.getProperty())) {
                    selectBuilder.append(",");
                    continue;
                }
                selectBuilder.append(" AS ").append(entityColumn.getProperty()).append(",");
                continue;
            }
            selectBuilder.append(",");
        }
        entityTable.setBaseSelect(selectBuilder.substring(0, selectBuilder.length() - 1));
        return entityTable.getBaseSelect();
    }

    public static synchronized void initEntityNameMap(Class<?> entityClass, Config config) {
        Table table;
        if (entityTableMap.get(entityClass) != null) {
            return;
        }
        Style style = config.getStyle();
        if (entityClass.isAnnotationPresent(NameStyle.class)) {
            NameStyle nameStyle = entityClass.getAnnotation(NameStyle.class);
            style = nameStyle.value();
        }
        EntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !(table = entityClass.getAnnotation(Table.class)).name().equals("")) {
            entityTable = new EntityTable(entityClass);
            entityTable.setTable(table);
        }
        if (entityTable == null) {
            entityTable = new EntityTable(entityClass);
            entityTable.setName(EntityBuilder.convertByStyle(entityClass.getSimpleName(), style));
        }
        entityTable.setEntityClassColumns(new LinkedHashSet<EntityColumn>());
        entityTable.setEntityClassPKColumns(new LinkedHashSet<EntityColumn>());
        List<EntityField> fields = config.isEnableMethodAnnotation() ? FieldSourceBuilder.getAll(entityClass) : FieldSourceBuilder.getFields(entityClass);
        for (EntityField field : fields) {
            if (config.isUseSimpleType() && !SimpleType.isSimpleType(field.getJavaType()) && (!config.isEnumAsSimpleType() || !Enum.class.isAssignableFrom(field.getJavaType()))) continue;
            EntityBuilder.processField(entityTable, style, field, config.getWrapKeyword());
        }
        if (entityTable.getEntityClassPKColumns().size() == 0) {
            entityTable.setEntityClassPKColumns(entityTable.getEntityClassColumns());
        }
        entityTable.initPropertyMap();
        entityTableMap.put(entityClass, entityTable);
    }

    private static void processField(EntityTable entityTable, Style style, EntityField field, String wrapKeyword) {
        if (field.isAnnotationPresent(Transient.class)) {
            return;
        }
        EntityColumn entityColumn = new EntityColumn(entityTable);
        entityColumn.setEntityField(field);
        if (field.isAnnotationPresent(Id.class)) {
            entityColumn.setId(true);
        }
        String columnName = null;
        if (field.isAnnotationPresent(Column.class)) {
            Column column = field.getAnnotation(Column.class);
            columnName = column.name();
            entityColumn.setUpdatable(column.updatable());
            entityColumn.setInsertable(column.insertable());
        }
        if (field.isAnnotationPresent(ColumnType.class)) {
            ColumnType columnType = field.getAnnotation(ColumnType.class);
            if (Assert.isEmpty(columnName) && Assert.isNotEmpty(columnType.column())) {
                columnName = columnType.column();
            }
            if (columnType.jdbcType() != JdbcType.UNDEFINED) {
                entityColumn.setJdbcType(columnType.jdbcType());
            }
            if (columnType.typeHandler() != UnknownTypeHandler.class) {
                entityColumn.setTypeHandler(columnType.typeHandler());
            }
        }
        if (Assert.isEmpty(columnName)) {
            columnName = EntityBuilder.convertByStyle(field.getName(), style);
        }
        if (Assert.isNotEmpty(wrapKeyword) && Words.containsWord(columnName)) {
            columnName = MessageFormat.format(wrapKeyword, columnName);
        }
        entityColumn.setProperty(field.getName());
        entityColumn.setColumn(columnName);
        entityColumn.setJavaType(field.getJavaType());
        if (field.isAnnotationPresent(OrderBy.class)) {
            OrderBy orderBy = field.getAnnotation(OrderBy.class);
            if (orderBy.value().equals("")) {
                entityColumn.setOrderBy("ASC");
            } else {
                entityColumn.setOrderBy(orderBy.value());
            }
        }
        if (field.isAnnotationPresent(SequenceGenerator.class)) {
            SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
            if (sequenceGenerator.sequenceName().equals("")) {
                throw new MapperException(entityTable.getEntityClass() + "\u5b57\u6bb5" + field.getName() + "\u7684\u6ce8\u89e3@SequenceGenerator\u672a\u6307\u5b9asequenceName!");
            }
            entityColumn.setSequenceName(sequenceGenerator.sequenceName());
        } else if (field.isAnnotationPresent(GeneratedValue.class)) {
            GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
            if (generatedValue.generator().equals("UUID")) {
                entityColumn.setUuid(true);
            } else if (generatedValue.generator().equals("JDBC")) {
                entityColumn.setIdentity(true);
                entityColumn.setGenerator("JDBC");
                entityTable.setKeyProperties(entityColumn.getProperty());
                entityTable.setKeyColumns(entityColumn.getColumn());
            } else if (generatedValue.strategy() == GenerationType.IDENTITY) {
                entityColumn.setIdentity(true);
                if (!generatedValue.generator().equals("")) {
                    String generator = null;
                    Identity identity = Identity.getDatabaseDialect(generatedValue.generator());
                    generator = identity != null ? identity.getIdentityRetrievalStatement() : generatedValue.generator();
                    entityColumn.setGenerator(generator);
                }
            } else {
                throw new MapperException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4ee5\u4e0b\u51e0\u79cd\u5f62\u5f0f:\n1.\u5168\u90e8\u6570\u636e\u5e93\u901a\u7528\u7684@GeneratedValue(generator=\"UUID\")\n2.useGeneratedKeys\u7684@GeneratedValue(generator=\\\"JDBC\\\")  \n3.\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"Mysql\"])");
            }
        }
        entityTable.getEntityClassColumns().add(entityColumn);
        if (entityColumn.isId()) {
            entityTable.getEntityClassPKColumns().add(entityColumn);
        }
    }

    private static String convertByStyle(String str, Style style) {
        switch (style) {
            case camelhump: {
                return EntityBuilder.camelhumpToUnderline(str);
            }
            case uppercase: {
                return str.toUpperCase();
            }
            case lowercase: {
                return str.toLowerCase();
            }
            case camelhumpAndLowercase: {
                return EntityBuilder.camelhumpToUnderline(str).toLowerCase();
            }
            case camelhumpAndUppercase: {
                return EntityBuilder.camelhumpToUnderline(str).toUpperCase();
            }
        }
        return str;
    }

    private static String camelhumpToUnderline(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (EntityBuilder.isUppercaseAlpha(c)) {
                sb.append('_').append(EntityBuilder.toLowerAscii(c));
                continue;
            }
            sb.append(c);
        }
        return sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowercaseAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static char toUpperAscii(char c) {
        if (EntityBuilder.isLowercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    public static char toLowerAscii(char c) {
        if (EntityBuilder.isUppercaseAlpha(c)) {
            c = (char)(c + 32);
        }
        return c;
    }
}

