/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class DingTalkProvider
extends DefaultProvider {
    public DingTalkProvider(Context context) {
        super(context, Registry.DINGTALK);
    }

    public DingTalkProvider(Context context, StateCache stateCache) {
        super(context, Registry.DINGTALK, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return AccToken.builder().accessCode(Callback2.getCode()).build();
    }

    @Override
    protected Object getUserInfo(AccToken oauthToken) {
        String code = oauthToken.getAccessCode();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tmp_auth_code", code);
        String response = Httpx.post(this.userInfoUrl(oauthToken), param);
        JSONObject object = JSON.parseObject((String)response);
        if (object.getIntValue("errcode") != 0) {
            throw new InstrumentException(object.getString("errmsg"));
        }
        object = object.getJSONObject("user_info");
        AccToken token = AccToken.builder().openId(object.getString("openid")).unionId(object.getString("unionid")).build();
        return Property.builder().uuid(object.getString("unionid")).nickname(object.getString("nick")).username(object.getString("nick")).gender(Normal.Gender.UNKNOWN).source(this.source.toString()).token(token).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("appid", this.context.getClientId()).queryParam("scope", "snsapi_login").queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        String timestamp = System.currentTimeMillis() + "";
        String urlEncodeSignature = DingTalkProvider.generateDingTalkSignature(this.context.getClientSecret(), timestamp);
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("signature", urlEncodeSignature).queryParam("timestamp", timestamp).queryParam("accessKey", this.context.getClientId()).build();
    }
}

