/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.aoju.bus.core.io.segment.BufferPool;
import org.aoju.bus.socket.origin.AioSession;
import org.aoju.bus.socket.origin.Message;
import org.aoju.bus.socket.origin.Protocol;
import org.aoju.bus.socket.origin.ServerConfig;
import org.aoju.bus.socket.origin.TcpAioSession;
import org.aoju.bus.socket.origin.TcpReadHandler;
import org.aoju.bus.socket.origin.TcpWriteHandler;

public class AioQuickClient<T> {
    protected ServerConfig<T> config = new ServerConfig();
    protected TcpAioSession<T> session;
    protected BufferPool bufferPool = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private SocketAddress localAddress;

    public AioQuickClient(String host, int port, Protocol<T> protocol, Message<T> messageProcessor) {
        this.config.setHost(host);
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public AioSession<T> start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException, ExecutionException, InterruptedException {
        AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(asynchronousChannelGroup);
        if (this.bufferPool == null) {
            this.bufferPool = new BufferPool(ServerConfig.getIntProperty("bus-socket.client.pageSize", 262144), 1, ServerConfig.getBoolProperty("bus-socket.client.page.isDirect", true));
        }
        if (this.config.getSocketOptions() != null) {
            for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        if (this.localAddress != null) {
            socketChannel.bind(this.localAddress);
        }
        socketChannel.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort())).get();
        this.session = new TcpAioSession<T>(socketChannel, this.config, new TcpReadHandler(), new TcpWriteHandler(), this.bufferPool.allocateBufferPage());
        this.session.initSession();
        return this.session;
    }

    public final AioSession<T> start() throws IOException, ExecutionException, InterruptedException {
        this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(2, r -> new Thread(r));
        return this.start(this.asynchronousChannelGroup);
    }

    public final void shutdown() {
        this.showdown0(false);
    }

    public final void shutdownNow() {
        this.showdown0(true);
    }

    private void showdown0(boolean flag) {
        if (this.session != null) {
            this.session.close(flag);
            this.session = null;
        }
        if (this.asynchronousChannelGroup != null) {
            this.asynchronousChannelGroup.shutdown();
        }
    }

    public final AioQuickClient<T> setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final <V> AioQuickClient<T> setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public final AioQuickClient<T> bindLocal(String local, int port) {
        this.localAddress = local == null ? new InetSocketAddress(port) : new InetSocketAddress(local, port);
        return this;
    }

    public final AioQuickClient<T> setBufferPagePool(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        return this;
    }

    public final AioQuickClient<T> setWriteQueueCapacity(int writeQueueCapacity) {
        this.config.setWriteQueueCapacity(writeQueueCapacity);
        return this;
    }
}

