/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.i18n;

import javax.validation.Validator;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.starter.i18n.I18nProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@EnableConfigurationProperties(value={I18nProperties.class})
public class I18nConfiguration {
    @Autowired
    I18nProperties properties;

    private ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource bundleMessageSource = new ResourceBundleMessageSource();
        bundleMessageSource.setDefaultEncoding(StringUtils.defaultString(this.properties.getDefaultEncoding(), "UTF-8"));
        bundleMessageSource.setBasenames(this.properties.getBaseNames());
        return bundleMessageSource;
    }

    @Bean
    public Validator getValidator() {
        LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
        validator.setValidationMessageSource((MessageSource)this.getMessageSource());
        return validator;
    }
}

