/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.preview;

import java.util.stream.Stream;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.bridge.LocalOfficePoolManager;
import org.aoju.bus.office.bridge.OnlineOfficePoolManager;
import org.aoju.bus.office.magic.family.RegistryInstanceHolder;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.provider.LocalOfficeProvider;
import org.aoju.bus.office.provider.OnlineOfficeProvider;
import org.aoju.bus.starter.preview.PreviewProperties;
import org.aoju.bus.starter.preview.PreviewProviderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={LocalOfficeProvider.class, OnlineOfficeProvider.class})
@EnableConfigurationProperties(value={PreviewProperties.class})
public class PreviewConfiguration {
    @Autowired
    PreviewProperties properties;

    @Bean
    public PreviewProviderService previewProviderFactory(OfficeManager localOfficeManager, OfficeManager onlineOfficeManager) {
        return new PreviewProviderService(((LocalOfficeProvider.Builder)((LocalOfficeProvider.Builder)LocalOfficeProvider.builder().officeManager(localOfficeManager)).formatRegistry(RegistryInstanceHolder.getInstance())).build(), OnlineOfficeProvider.make(onlineOfficeManager));
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public OfficeManager localOfficeManager() {
        LocalOfficePoolManager.Builder builder = LocalOfficePoolManager.builder();
        if (!StringUtils.isBlank(this.properties.getPortNumbers())) {
            builder.portNumbers(ArrayUtils.toPrimitive((Integer[])Stream.of(StringUtils.split((CharSequence)this.properties.getPortNumbers(), ",")).map(str -> NumberUtils.toInt(str, 8102)).toArray(Integer[]::new)));
        }
        builder.officeHome(this.properties.getOfficeHome());
        builder.workingDir(this.properties.getWorkingDir());
        builder.templateProfileDir(this.properties.getTemplateProfileDir());
        builder.killExistingProcess(this.properties.isKillExistingProcess());
        builder.processTimeout(this.properties.getProcessTimeout());
        builder.processRetryInterval(this.properties.getProcessRetryInterval());
        builder.taskExecutionTimeout(this.properties.getTaskExecutionTimeout());
        builder.maxTasksPerProcess(this.properties.getMaxTasksPerProcess());
        builder.taskQueueTimeout(this.properties.getTaskQueueTimeout());
        String processManagerClass = this.properties.getProcessManagerClass();
        if (StringUtils.isNotEmpty(processManagerClass)) {
            builder.processManager(processManagerClass);
        } else {
            builder.processManager(Builder.findBestProcessManager());
        }
        return builder.build();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public OfficeManager onlineOfficeManager() {
        OnlineOfficePoolManager.Builder builder = OnlineOfficePoolManager.builder();
        builder.urlConnection(this.properties.getUrl());
        builder.poolSize(this.properties.getPoolSize());
        builder.workingDir(this.properties.getWorkingDir());
        builder.taskExecutionTimeout(this.properties.getTaskExecutionTimeout());
        builder.taskQueueTimeout(this.properties.getTaskQueueTimeout());
        return builder.build();
    }
}

