package org.aoju.bus.validate.annotation;


import org.aoju.bus.validate.Builder;

import java.lang.annotation.*;

/**
 * 如果放在一个参数上，将在方法/构造函数体的开头插入一个空值检查，
 * 抛出一个{@code NullPointerException}，参数名作为消息。
 * 如果放在字段上，任何为该字段赋值的生成方法也将产生这些空检查。
 *
 * @author Kimi Liu
 * @version 5.5.0
 * @since JDK 1.8+
 */
@Target({ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Retention(RetentionPolicy.CLASS)
@Documented
public @interface NonNull {

    /**
     * 默认使用的异常码
     *
     * @return the string
     */
    String errcode() default Builder.DEFAULT_ERRCODE;

    /**
     * 默认使用的异常信息
     *
     * @return the string
     */
    String errmsg() default "${field}不能为空";

    /**
     * 校验器组
     *
     * @return the array
     */
    String[] group() default {};

    /**
     * 被校验字段名称
     *
     * @return the string
     */
    String field() default Builder.DEFAULT_FIELD;

}
