/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.map.CamelCaseLinkedMap;
import org.aoju.bus.core.map.CamelCaseMap;
import org.aoju.bus.core.map.MapBuilder;
import org.aoju.bus.core.map.MapProxy;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class MapUtils {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        int initialCapacity = (int)((float)size / 0.75f);
        return isOrder ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtils.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isOrder) {
        return MapUtils.newHashMap(16, isOrder);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (!MapUtils.isEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        if (mapType.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        try {
            return (Map)ReflectUtils.newInstance(mapType, new Object[0]);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return MapUtils.of(key, value, false);
    }

    public static <K, V> HashMap<K, V> of(K key, V value, boolean isOrder) {
        HashMap<K, V> map = MapUtils.newHashMap(isOrder);
        map.put(key, value);
        return map;
    }

    public static HashMap<Object, Object> of(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object value;
            Object key;
            Iterator iter;
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length <= 1) continue;
                map.put(entry[0], entry[1]);
                continue;
            }
            if (object instanceof Iterable) {
                iter = ((Iterable)object).iterator();
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            if (object instanceof Iterator) {
                iter = (Iterator)object;
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(StringUtils.format("Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i, object));
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        HashMap<K, ArrayList<Object>> resultMap = new HashMap<K, ArrayList<Object>>();
        if (CollUtils.isEmpty(mapList)) {
            return resultMap;
        }
        for (Map<K, V> map : mapList) {
            Set<Map.Entry<K, V>> entrySet = map.entrySet();
            for (Map.Entry<K, V> entry : entrySet) {
                K key = entry.getKey();
                ArrayList<Object> valueList = (ArrayList<Object>)resultMap.get(key);
                if (null == valueList) {
                    valueList = CollUtils.newArrayList(entry.getValue());
                    resultMap.put(key, valueList);
                    continue;
                }
                valueList.add(entry.getValue());
            }
        }
        return resultMap;
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        ArrayList<Map<K, V>> resultList = new ArrayList<Map<K, V>>();
        if (MapUtils.isEmpty(listMap)) {
            return resultList;
        }
        boolean isEnd = true;
        int index = 0;
        do {
            isEnd = true;
            HashMap map = new HashMap();
            for (Map.Entry<K, Iterable<V>> entry : listMap.entrySet()) {
                ArrayList<V> vList = CollUtils.newArrayList(entry.getValue());
                int vListSize = vList.size();
                if (index >= vListSize) continue;
                map.put(entry.getKey(), vList.get(index));
                if (index == vListSize - 1) continue;
                isEnd = false;
            }
            if (!map.isEmpty()) {
                resultList.add(map);
            }
            ++index;
        } while (!isEnd);
        return resultList;
    }

    public static <K, V> Map<K, V> toCamelCaseMap(Map<K, V> map) {
        return map instanceof LinkedHashMap ? new CamelCaseLinkedMap<K, V>(map) : new CamelCaseMap<K, V>(map);
    }

    public static Object[][] toObjectArray(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Object[][] result = new Object[map.size()][2];
        if (map.isEmpty()) {
            return result;
        }
        int index = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result[index][0] = entry.getKey();
            result[index][1] = entry.getValue();
            ++index;
        }
        return result;
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator) {
        return MapUtils.join(map, separator, keyValueSeparator, false);
    }

    public static <K, V> String joinIgnoreNull(Map<K, V> map, String separator, String keyValueSeparator) {
        return MapUtils.join(map, separator, keyValueSeparator, true);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, boolean isIgnoreNull) {
        StringBuilder strBuilder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (isIgnoreNull && (entry.getKey() == null || entry.getValue() == null)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                strBuilder.append(separator);
            }
            strBuilder.append(Convert.toString(entry.getKey())).append(keyValueSeparator).append(Convert.toString(entry.getValue()));
        }
        return strBuilder.toString();
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        Map<K, V> map2 = ObjectUtils.clone(map);
        if (MapUtils.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry<K, V> modified = editor.edit(entry);
            if (null == modified) continue;
            map2.put(modified.getKey(), modified.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        Map<K, V> map2 = ObjectUtils.clone(map);
        if (MapUtils.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.accept(entry)) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, K ... keys) {
        Map<K, V> map2 = ObjectUtils.clone(map);
        if (MapUtils.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (K key : keys) {
            if (!map.containsKey(key)) continue;
            map2.put(key, map.get(key));
        }
        return map2;
    }

    public static <T> Map<T, T> reverse(Map<T, T> map) {
        return MapUtils.filter(map, (Map.Entry<K, V> t) -> new Map.Entry<T, T>((Map.Entry)t){
            final /* synthetic */ Map.Entry val$t;
            {
                this.val$t = entry;
            }

            @Override
            public T getKey() {
                return this.val$t.getValue();
            }

            @Override
            public T getValue() {
                return this.val$t.getKey();
            }

            @Override
            public T setValue(T value) {
                throw new UnsupportedOperationException("Unsupported setValue method !");
            }
        });
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map) {
        return MapUtils.sort(map, null);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result;
        if (map instanceof TreeMap) {
            result = (TreeMap<K, V>)map;
            if (null == comparator || comparator.equals(result.comparator())) {
                return result;
            }
        } else {
            result = MapUtils.newTreeMap(map, comparator);
        }
        return result;
    }

    public static MapProxy createProxy(Map<?, ?> map) {
        return MapProxy.create(map);
    }

    public static <K, V> MapBuilder<K, V> builder() {
        return MapUtils.builder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static <K, V> MapBuilder<K, V> builder(K k, V v) {
        return MapUtils.builder(new HashMap()).put(k, v);
    }

    public static <K, V> Map<K, V> getAny(Map<K, V> map, K ... keys) {
        return MapUtils.filter(map, (Map.Entry<K, V> entry) -> ArrayUtils.contains(keys, entry.getKey()));
    }

    public static String getString(Map<?, ?> map, Object key) {
        return MapUtils.get(map, key, String.class);
    }

    public static Integer getInt(Map<?, ?> map, Object key) {
        return MapUtils.get(map, key, Integer.class);
    }

    public static Double getDouble(Map<?, ?> map, Object key) {
        return MapUtils.get(map, key, Double.class);
    }

    public static Float getFloat(Map<?, ?> map, Object key) {
        return MapUtils.get(map, key, Float.class);
    }

    public static Short getShort(Map<?, ?> map, Object key) {
        return MapUtils.get(map, key, Short.class);
    }

    public static Boolean getBool(Map<?, ?> map, Object key) {
        return MapUtils.get(map, key, Boolean.class);
    }

    public static Character getChar(Map<?, ?> map, Object key) {
        return MapUtils.get(map, key, Character.class);
    }

    public static Long getLong(Map<?, ?> map, Object key) {
        return MapUtils.get(map, key, Long.class);
    }

    public static Date getDate(Map<?, ?> map, Object key) {
        return MapUtils.get(map, key, Date.class);
    }

    public static <T> T get(Map<?, ?> map, Object key, Class<T> type) {
        return null == map ? null : (T)Convert.convert(type, map.get(key));
    }

    public static <K, V> Map<K, V> renameKey(Map<K, V> map, K oldKey, K newKey) {
        if (MapUtils.isNotEmpty(map) && map.containsKey(oldKey)) {
            if (map.containsKey(newKey)) {
                throw new IllegalArgumentException(StringUtils.format("The key '{}' exist !", newKey));
            }
            map.put(newKey, map.remove(oldKey));
        }
        return map;
    }
}

