/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.mail;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dm.model.v20151123.SingleSendMailRequest;
import com.aliyuncs.dm.model.v20151123.SingleSendMailResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.extra.mail.AliMailEntity;
import org.aoju.bus.extra.mail.AliMailRegion;
import org.aoju.bus.extra.mail.AliMailResult;

public class AliMailService {
    static final String JOIN_SPLIT = ",";
    private String accessKey;
    private String accessSecret;
    private IAcsClient client;
    private String accountName;
    private boolean replyToAddress;
    private int addressType;
    private AliMailRegion region;

    public AliMailResult send(AliMailEntity entity) throws InstrumentException {
        try {
            this.client = new DefaultAcsClient((IClientProfile)DefaultProfile.getProfile((String)this.region.getValue(), (String)this.accessKey, (String)this.accessSecret));
            if (StringUtils.isEmpty(entity.getContent())) {
                throw new InstrumentException("Email content cannot be empty");
            }
            if (StringUtils.isEmpty(entity.getToAddress())) {
                throw new InstrumentException("Email address cannot be empty");
            }
            if (StringUtils.isEmpty(entity.getSubject())) {
                throw new InstrumentException("Email subject cannot be empty");
            }
            SingleSendMailRequest request = new SingleSendMailRequest();
            request.setAccountName(this.accountName);
            request.setFromAlias(entity.getFormAlias());
            request.setAddressType(Integer.valueOf(this.addressType));
            if (!StringUtils.isEmpty(entity.getTagName())) {
                request.setTagName(entity.getTagName());
            }
            request.setReplyToAddress(Boolean.valueOf(this.replyToAddress));
            request.setToAddress(String.join((CharSequence)JOIN_SPLIT, entity.getToAddress()));
            request.setSubject(entity.getSubject());
            this.switchBody(request, entity.getContent(), entity.getContentType());
            SingleSendMailResponse response = (SingleSendMailResponse)this.client.getAcsResponse((AcsRequest)request);
            return AliMailResult.builder().success(!StringUtils.isEmpty(response.getRequestId())).build();
        }
        catch (Exception e) {
            throw new InstrumentException(e.getMessage(), e);
        }
    }

    private void switchBody(SingleSendMailRequest request, String content, AliMailEntity.ContentType contentType) {
        switch (contentType) {
            case HTML: {
                request.setHtmlBody(content);
                break;
            }
            default: {
                request.setTextBody(content);
            }
        }
    }

    public AliMailService(String accessKey, String accessSecret, IAcsClient client, String accountName, boolean replyToAddress, int addressType, AliMailRegion region) {
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.client = client;
        this.accountName = accountName;
        this.replyToAddress = replyToAddress;
        this.addressType = addressType;
        this.region = region;
    }
}

