/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ImageUtils;
import org.aoju.bus.extra.qrcode.BufferedImageLuminanceSource;
import org.aoju.bus.extra.qrcode.QrConfig;

public class QrCodeUtils {
    public static byte[] generatePng(String content, int width, int height) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeUtils.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static byte[] generatePng(String content, QrConfig config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeUtils.generate(content, config, "png", out);
        return out.toByteArray();
    }

    public static File generate(String content, int width, int height, File targetFile) {
        BufferedImage image = QrCodeUtils.generate(content, width, height);
        ImageUtils.write(image, targetFile);
        return targetFile;
    }

    public static File generate(String content, QrConfig config, File targetFile) {
        BufferedImage image = QrCodeUtils.generate(content, config);
        ImageUtils.write(image, targetFile);
        return targetFile;
    }

    public static void generate(String content, int width, int height, String imageType, OutputStream out) {
        BufferedImage image = QrCodeUtils.generate(content, width, height);
        ImageUtils.write((Image)image, imageType, out);
    }

    public static void generate(String content, QrConfig config, String imageType, OutputStream out) {
        BufferedImage image = QrCodeUtils.generate(content, config);
        ImageUtils.write((Image)image, imageType, out);
    }

    public static BufferedImage generate(String content, int width, int height) {
        return QrCodeUtils.generate(content, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, BarcodeFormat format, int width, int height) {
        return QrCodeUtils.generate(content, format, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, QrConfig config) {
        return QrCodeUtils.generate(content, BarcodeFormat.QR_CODE, config);
    }

    public static BufferedImage generate(String content, BarcodeFormat format, QrConfig config) {
        BitMatrix bitMatrix = QrCodeUtils.encode(content, format, config);
        BufferedImage image = QrCodeUtils.toImage(bitMatrix, config.foreColor, config.backColor);
        Image logoImage = config.img;
        if (null != logoImage && BarcodeFormat.QR_CODE == format) {
            int height;
            int width;
            int qrHeight;
            int qrWidth = image.getWidth();
            if (qrWidth < (qrHeight = image.getHeight())) {
                width = qrWidth / config.ratio;
                height = logoImage.getHeight(null) * width / logoImage.getWidth(null);
            } else {
                height = qrHeight / config.ratio;
                width = logoImage.getWidth(null) * height / logoImage.getHeight(null);
            }
            org.aoju.bus.core.image.Image.from(image).pressImage(org.aoju.bus.core.image.Image.from(logoImage).round(0.3).getImg(), new Rectangle(width, height), 1.0f);
        }
        return image;
    }

    public static BitMatrix encode(String content, int width, int height) {
        return QrCodeUtils.encode(content, BarcodeFormat.QR_CODE, width, height);
    }

    public static BitMatrix encode(String content, QrConfig config) {
        return QrCodeUtils.encode(content, BarcodeFormat.QR_CODE, config);
    }

    public static BitMatrix encode(String content, BarcodeFormat format, int width, int height) {
        return QrCodeUtils.encode(content, format, new QrConfig(width, height));
    }

    public static BitMatrix encode(String content, BarcodeFormat format, QrConfig config) {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        if (null == config) {
            config = new QrConfig();
        }
        try {
            bitMatrix = multiFormatWriter.encode(content, format, config.width, config.height, config.toHints());
        }
        catch (WriterException e) {
            throw new InstrumentException(e);
        }
        return bitMatrix;
    }

    public static String decode(InputStream qrCodeInputstream) {
        return QrCodeUtils.decode(ImageUtils.read(qrCodeInputstream));
    }

    public static String decode(File qrCodeFile) {
        return QrCodeUtils.decode(ImageUtils.read(qrCodeFile));
    }

    public static String decode(Image image) {
        return QrCodeUtils.decode(image, true, false);
    }

    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        Result result;
        MultiFormatReader formatReader = new MultiFormatReader();
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(ImageUtils.toBufferedImage(image));
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
        HashMap<DecodeHintType, Comparable<java.nio.charset.Charset>> hints = new HashMap<DecodeHintType, Comparable<java.nio.charset.Charset>>();
        hints.put(DecodeHintType.CHARACTER_SET, Charset.UTF_8);
        hints.put(DecodeHintType.TRY_HARDER, Boolean.valueOf(isTryHarder));
        hints.put(DecodeHintType.PURE_BARCODE, Boolean.valueOf(isPureBarcode));
        try {
            result = formatReader.decode(binaryBitmap, hints);
        }
        catch (NotFoundException e) {
            hints.remove(DecodeHintType.PURE_BARCODE);
            try {
                result = formatReader.decode(binaryBitmap, hints);
            }
            catch (NotFoundException e1) {
                throw new InstrumentException(e1);
            }
        }
        return result.getText();
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, int backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? foreColor : backColor);
            }
        }
        return image;
    }
}

