/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.mapper.builder.Builder;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.mapper.criteria.Criteria;
import org.aoju.bus.mapper.criteria.OrderBy;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.aoju.bus.mapper.entity.EntityTable;
import org.aoju.bus.mapper.entity.EntityTableName;

public class Condition
implements EntityTableName {
    protected String orderByClause;
    protected boolean distinct;
    protected boolean exists;
    protected boolean notNull;
    protected boolean forUpdate;
    protected Set<String> selectColumns;
    protected Set<String> excludeColumns;
    protected String countColumn;
    protected List<Criteria> oredCriteria;
    protected Class<?> entityClass;
    protected EntityTable table;
    protected Map<String, EntityColumn> propertyMap;
    protected String tableName;
    protected OrderBy ORDERBY;

    public Condition(Class<?> clazz) {
        this(clazz, true);
    }

    public Condition(Class<?> clazz, boolean exists) {
        this(clazz, exists, false);
    }

    public Condition(Class<?> entityClass, boolean exists, boolean notNull) {
        this.exists = exists;
        this.notNull = notNull;
        this.oredCriteria = new ArrayList<Criteria>();
        this.entityClass = entityClass;
        this.table = EntityBuilder.getEntityTable(entityClass);
        this.propertyMap = this.table.getPropertyMap();
        this.ORDERBY = new OrderBy(this, this.propertyMap);
    }

    private Condition(Builder builder) {
        this.exists = builder.exists;
        this.notNull = builder.notNull;
        this.distinct = builder.distinct;
        this.entityClass = builder.entityClass;
        this.propertyMap = builder.propertyMap;
        this.selectColumns = builder.selectColumns;
        this.excludeColumns = builder.excludeColumns;
        this.oredCriteria = builder.criterias;
        this.forUpdate = builder.forUpdate;
        this.tableName = builder.tableName;
        if (!Assert.isEmpty(builder.orderByClause.toString())) {
            this.orderByClause = builder.orderByClause.toString();
        }
    }

    public static Builder builder(Class<?> entityClass) {
        return new Builder(entityClass);
    }

    public OrderBy orderBy(String property) {
        this.ORDERBY.orderBy(property);
        return this.ORDERBY;
    }

    public Condition excludeProperties(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.excludeColumns == null) {
                this.excludeColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) {
                    throw new InstrumentException("\u7c7b " + this.entityClass.getSimpleName() + " \u4e0d\u5305\u542b\u5c5e\u6027 '" + property + "',\u6216\u8be5\u5c5e\u6027\u88ab@Transient\u6ce8\u91ca\uff01");
                }
                this.excludeColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public Condition selectProperties(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.selectColumns == null) {
                this.selectColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) {
                    throw new InstrumentException("\u7c7b " + this.entityClass.getSimpleName() + " \u4e0d\u5305\u542b\u5c5e\u6027 '" + property + "',\u6216\u8be5\u5c5e\u6027\u88ab@Transient\u6ce8\u91ca\uff01");
                }
                this.selectColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public void or(Criteria criteria) {
        criteria.setAndOr("or");
        this.oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = this.createCriteriaInternal();
        criteria.setAndOr("or");
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public void and(Criteria criteria) {
        criteria.setAndOr("and");
        this.oredCriteria.add(criteria);
    }

    public Criteria and() {
        Criteria criteria = this.createCriteriaInternal();
        criteria.setAndOr("and");
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = this.createCriteriaInternal();
        if (this.oredCriteria.size() == 0) {
            criteria.setAndOr("and");
            this.oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.propertyMap, this.exists, this.notNull);
        return criteria;
    }

    public void clear() {
        this.oredCriteria.clear();
        this.orderByClause = null;
        this.distinct = false;
    }

    public String getCountColumn() {
        return this.countColumn;
    }

    @Override
    public String getDynamicTableName() {
        return this.tableName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public List<Criteria> getOredCriteria() {
        return this.oredCriteria;
    }

    public Set<String> getSelectColumns() {
        if ((this.selectColumns == null || this.selectColumns.size() <= 0) && this.excludeColumns != null && this.excludeColumns.size() > 0) {
            Collection<EntityColumn> entityColumns = this.propertyMap.values();
            this.selectColumns = new LinkedHashSet<String>(entityColumns.size() - this.excludeColumns.size());
            for (EntityColumn column : entityColumns) {
                if (this.excludeColumns.contains(column.getColumn())) continue;
                this.selectColumns.add(column.getColumn());
            }
        }
        return this.selectColumns;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public void setCountProperty(String property) {
        if (this.propertyMap.containsKey(property)) {
            this.countColumn = this.propertyMap.get(property).getColumn();
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

