/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class MicrosoftProvider
extends DefaultProvider {
    public MicrosoftProvider(Context context) {
        super(context, Registry.MICROSOFT);
    }

    public MicrosoftProvider(Context context, StateCache stateCache) {
        super(context, Registry.MICROSOFT, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return this.getToken(this.accessTokenUrl(Callback2.getCode()));
    }

    private AccToken getToken(String accessTokenUrl) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "https://login.microsoftonline.com");
        String response = Httpx.post(accessTokenUrl, MicrosoftProvider.parseQueryToMap(accessTokenUrl), header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).scope(object.getString("scope")).tokenType(object.getString("token_type")).refreshToken(object.getString("refresh_token")).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getString("error_description"));
        }
    }

    @Override
    protected Property getUserInfo(AccToken oauthToken) {
        String token = oauthToken.getAccessToken();
        String tokenType = oauthToken.getTokenType();
        String jwt = tokenType + " " + token;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", jwt);
        String response = Httpx.get(this.userInfoUrl(oauthToken), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("id")).username(object.getString("userPrincipalName")).nickname(object.getString("displayName")).location(object.getString("officeLocation")).email(object.getString("mail")).gender(Normal.Gender.UNKNOWN).token(oauthToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken token) {
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(token.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getClientId()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("response_mode", "query").queryParam("scope", "offline_access%20user.read%20mail.read").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.context.getClientId()).queryParam("client_secret", this.context.getClientSecret()).queryParam("grant_type", "authorization_code").queryParam("scope", "user.read%20mail.read").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return Builder.fromBaseUrl(this.source.refresh()).queryParam("client_id", this.context.getClientId()).queryParam("client_secret", this.context.getClientSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("scope", "user.read%20mail.read").queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }
}

