/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office;

import java.util.Objects;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.process.PumpStreamHandler;
import org.aoju.bus.office.process.StreamPumper;

public class Expense {
    private final Process process;
    private final PumpStreamHandler streamHandler;

    public Expense(Process process) {
        Objects.requireNonNull(process, "process must not be null");
        this.process = process;
        this.streamHandler = new PumpStreamHandler(new StreamPumper(process.getInputStream(), line -> Logger.info(line, new Object[0])), new StreamPumper(process.getErrorStream(), line -> Logger.error(line, new Object[0])));
        this.streamHandler.start();
    }

    public Process getProcess() {
        return this.process;
    }

    public Integer getExitCode() {
        try {
            int exitValue = this.process.exitValue();
            this.streamHandler.stop();
            return exitValue;
        }
        catch (IllegalThreadStateException ex) {
            Logger.trace("The Office process has not yet terminated.", new Object[0]);
            return null;
        }
    }
}

