/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.bridge;

import java.io.File;
import java.util.Arrays;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.metric.AbstractOfficePoolManager;
import org.aoju.bus.office.metric.InstalledOfficeHolder;
import org.aoju.bus.office.metric.OfficeProcessEntryManager;
import org.aoju.bus.office.metric.OfficeProcessManagerPoolBuilder;
import org.aoju.bus.office.process.ProcessManager;

public final class LocalOfficePoolManager
extends AbstractOfficePoolManager {
    private final UnoUrl[] unoUrls;

    private LocalOfficePoolManager(UnoUrl[] unoUrls, OfficeProcessManagerPoolBuilder config) {
        super(unoUrls.length, config);
        this.unoUrls = Arrays.copyOf(unoUrls, unoUrls.length);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LocalOfficePoolManager make() {
        return LocalOfficePoolManager.builder().build();
    }

    public static LocalOfficePoolManager install() {
        return ((Builder)LocalOfficePoolManager.builder().install()).build();
    }

    protected OfficeProcessEntryManager[] createPoolEntries() {
        return (OfficeProcessEntryManager[])Arrays.stream(this.unoUrls).map(officeUrl -> new OfficeProcessEntryManager((UnoUrl)officeUrl, (OfficeProcessManagerPoolBuilder)this.config)).toArray(OfficeProcessEntryManager[]::new);
    }

    public static final class Builder
    extends AbstractOfficePoolManager.AbstractOfficeManagerPoolBuilder<Builder> {
        private String[] pipeNames;
        private int[] portNumbers;
        private File officeHome;
        private ProcessManager processManager;
        private String[] runAsArgs;
        private File templateProfileDir;
        private boolean useDefaultOnInvalidTemplateProfileDir;
        private boolean killExistingProcess = true;
        private long processTimeout = 120000L;
        private long processRetryInterval = 250L;
        private int maxTasksPerProcess = 200;
        private boolean disableOpengl = false;

        private Builder() {
        }

        @Override
        public LocalOfficePoolManager build() {
            if (ObjectUtils.isEmpty(this.officeHome)) {
                this.officeHome = org.aoju.bus.office.Builder.getDefaultOfficeHome();
            }
            if (ObjectUtils.isEmpty(this.workingDir)) {
                this.workingDir = new File(System.getProperty("java.io.tmpdir"));
            }
            if (ObjectUtils.isEmpty(this.processManager)) {
                this.processManager = org.aoju.bus.office.Builder.findBestProcessManager();
            }
            org.aoju.bus.office.Builder.validateOfficeHome(this.officeHome);
            org.aoju.bus.office.Builder.validateOfficeWorkingDirectory(this.workingDir);
            if (this.useDefaultOnInvalidTemplateProfileDir) {
                try {
                    org.aoju.bus.office.Builder.validateOfficeTemplateProfileDirectory(this.templateProfileDir);
                }
                catch (IllegalStateException ex) {
                    this.templateProfileDir = null;
                    Logger.warn("Falling back to default templateProfileDir. Cause: ", ex.getMessage());
                }
            } else {
                org.aoju.bus.office.Builder.validateOfficeTemplateProfileDirectory(this.templateProfileDir);
            }
            UnoUrl[] unoUrls = org.aoju.bus.office.Builder.buildOfficeUrls(this.portNumbers, this.pipeNames);
            OfficeProcessManagerPoolBuilder config = new OfficeProcessManagerPoolBuilder(this.officeHome, this.workingDir, this.processManager);
            config.setRunAsArgs(this.runAsArgs);
            config.setTemplateProfileDir(this.templateProfileDir);
            config.setKillExistingProcess(this.killExistingProcess);
            config.setProcessTimeout(this.processTimeout);
            config.setProcessRetryInterval(this.processRetryInterval);
            config.setMaxTasksPerProcess(this.maxTasksPerProcess);
            config.setDisableOpengl(this.disableOpengl);
            config.setTaskExecutionTimeout(this.taskExecutionTimeout);
            config.setTaskQueueTimeout(this.taskQueueTimeout);
            LocalOfficePoolManager manager = new LocalOfficePoolManager(unoUrls, config);
            if (this.install) {
                InstalledOfficeHolder.setInstance(manager);
            }
            return manager;
        }

        public Builder pipeNames(String ... pipeNames) {
            Assert.isTrue(pipeNames != null && pipeNames.length > 0, "The pipe name list must not be empty", new Object[0]);
            this.pipeNames = ArrayUtils.clone(pipeNames);
            return this;
        }

        public Builder portNumbers(int ... portNumbers) {
            Assert.isTrue(portNumbers != null && portNumbers.length > 0, "The port number list must not be empty", new Object[0]);
            this.portNumbers = ArrayUtils.clone(portNumbers);
            return this;
        }

        public Builder officeHome(File officeHome) {
            this.officeHome = officeHome;
            return this;
        }

        public Builder officeHome(String officeHome) {
            return StringUtils.isBlank(officeHome) ? this : this.officeHome(new File(officeHome));
        }

        public Builder processManager(ProcessManager processManager) {
            Assert.notNull(processManager, "The process manager must not be null", new Object[0]);
            this.processManager = processManager;
            return this;
        }

        public Builder processManager(String processManagerClass) {
            try {
                return StringUtils.isBlank(processManagerClass) ? this : this.processManager((ProcessManager)Class.forName(processManagerClass).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new IllegalArgumentException("Unable to create a Process manager from the specified class name: " + processManagerClass, ex);
            }
        }

        public Builder runAsArgs(String ... runAsArgs) {
            Assert.isTrue(runAsArgs != null && runAsArgs.length > 0, "The runAs argument list must not be empty", new Object[0]);
            this.runAsArgs = ArrayUtils.clone(runAsArgs);
            return this;
        }

        public Builder templateProfileDir(File templateProfileDir) {
            this.templateProfileDir = templateProfileDir;
            return this;
        }

        public Builder templateProfileDir(String templateProfileDir) {
            return StringUtils.isBlank(templateProfileDir) ? this : this.templateProfileDir(new File(templateProfileDir));
        }

        public Builder templateProfileDirOrDefault(File templateProfileDir) {
            this.useDefaultOnInvalidTemplateProfileDir = true;
            this.templateProfileDir = templateProfileDir;
            return this;
        }

        public Builder templateProfileDirOrDefault(String templateProfileDir) {
            return StringUtils.isBlank(templateProfileDir) ? this : this.templateProfileDirOrDefault(new File(templateProfileDir));
        }

        public Builder killExistingProcess(boolean killExistingProcess) {
            this.killExistingProcess = killExistingProcess;
            return this;
        }

        public Builder processTimeout(long processTimeout) {
            this.processTimeout = processTimeout;
            return this;
        }

        public Builder processRetryInterval(long processRetryInterval) {
            this.processRetryInterval = processRetryInterval;
            return this;
        }

        public Builder maxTasksPerProcess(int maxTasksPerProcess) {
            this.maxTasksPerProcess = maxTasksPerProcess;
            return this;
        }

        public Builder disableOpengl(boolean disableOpengl) {
            this.disableOpengl = disableOpengl;
            return this;
        }
    }
}

