/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.Objects;

public class StreamPumper
extends Thread {
    private final InputStream stream;
    private final LineConsumer consumer;

    public StreamPumper(InputStream stream, LineConsumer consumer) {
        Objects.requireNonNull(stream, "stream must not be null");
        Objects.requireNonNull(stream, "consumer must not be null");
        this.stream = stream;
        this.consumer = consumer;
        this.setDaemon(true);
    }

    public LineConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void run() {
        try (BufferedReader bufferedReader = new BufferedReader(Channels.newReader(Channels.newChannel(this.stream), "UTF-8"));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                this.consumer.consume(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface LineConsumer {
        public void consume(String var1);
    }
}

