/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.segment.BufferPage;
import org.aoju.bus.core.io.segment.VirtualBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.AioSession;
import org.aoju.bus.socket.origin.Message;
import org.aoju.bus.socket.origin.ServerConfig;
import org.aoju.bus.socket.origin.StateMachine;
import org.aoju.bus.socket.origin.TcpReadHandler;
import org.aoju.bus.socket.origin.TcpWriteHandler;
import org.aoju.bus.socket.origin.WriteBuffer;

class TcpAioSession<T>
extends AioSession<T> {
    protected AsynchronousSocketChannel channel;
    protected VirtualBuffer readBuffer;
    protected VirtualBuffer writeBuffer;
    protected byte status = (byte)3;
    private Semaphore semaphore = new Semaphore(1);
    private TcpReadHandler<T> readCompletionHandler;
    private TcpWriteHandler<T> writeCompletionHandler;
    private ServerConfig<T> ioServerConfig;
    private InputStream inputStream;
    private WriteBuffer byteBuf;

    TcpAioSession(AsynchronousSocketChannel channel, ServerConfig<T> config, TcpReadHandler<T> readCompletionHandler, TcpWriteHandler<T> writeCompletionHandler, BufferPage bufferPage) {
        this.channel = channel;
        this.readCompletionHandler = readCompletionHandler;
        this.writeCompletionHandler = writeCompletionHandler;
        this.ioServerConfig = config;
        this.readBuffer = bufferPage.allocate(config.getReadBufferSize());
        this.byteBuf = new WriteBuffer(bufferPage, var -> {
            if (!this.semaphore.tryAcquire()) {
                return null;
            }
            this.writeBuffer = var.poll();
            if (this.writeBuffer == null) {
                this.semaphore.release();
            } else {
                this.continueWrite(this.writeBuffer);
            }
            return null;
        }, this.ioServerConfig.getWriteQueueCapacity());
        config.getProcessor().stateEvent(this, StateMachine.NEW_SESSION, null);
    }

    void initSession() {
        this.continueRead();
    }

    void writeToChannel() {
        if (this.writeBuffer == null) {
            this.writeBuffer = this.byteBuf.poll();
        } else if (!this.writeBuffer.buffer().hasRemaining()) {
            this.writeBuffer.clean();
            this.writeBuffer = this.byteBuf.poll();
        }
        if (this.writeBuffer != null) {
            this.continueWrite(this.writeBuffer);
            return;
        }
        this.semaphore.release();
        if (this.status != 3) {
            this.close();
        } else if (!this.byteBuf.isClosed()) {
            this.byteBuf.flush();
        }
    }

    protected final void readFromChannel0(ByteBuffer buffer) {
        this.channel.read(buffer, this, this.readCompletionHandler);
    }

    protected final void writeToChannel0(ByteBuffer buffer) {
        this.channel.write(buffer, 0L, TimeUnit.MILLISECONDS, this, this.writeCompletionHandler);
    }

    @Override
    public final WriteBuffer writeBuffer() {
        return this.byteBuf;
    }

    @Override
    public synchronized void close(boolean immediate) {
        if (this.status == 1) {
            Logger.warn("ignore, session:{} is closed:", this.getSessionID());
            return;
        }
        this.status = (byte)(immediate ? 1 : 2);
        if (immediate) {
            try {
                if (!this.byteBuf.isClosed()) {
                    this.byteBuf.close();
                }
                this.byteBuf = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.readBuffer.clean();
            this.readBuffer = null;
            if (this.writeBuffer != null) {
                this.writeBuffer.clean();
                this.writeBuffer = null;
            }
            try {
                this.channel.shutdownInput();
            }
            catch (IOException e) {
                Logger.debug(e.getMessage(), e);
            }
            try {
                this.channel.shutdownOutput();
            }
            catch (IOException e) {
                Logger.debug(e.getMessage(), e);
            }
            try {
                this.channel.close();
            }
            catch (IOException e) {
                Logger.debug("close session exception", e);
            }
            this.ioServerConfig.getProcessor().stateEvent(this, StateMachine.SESSION_CLOSED, null);
        } else if (!(this.writeBuffer != null && this.writeBuffer.buffer().hasRemaining() || this.byteBuf.hasData())) {
            this.close(true);
        } else {
            this.ioServerConfig.getProcessor().stateEvent(this, StateMachine.SESSION_CLOSING, null);
            if (!this.byteBuf.isClosed()) {
                this.byteBuf.flush();
            }
        }
    }

    @Override
    public final String getSessionID() {
        return "aioSession-" + this.hashCode();
    }

    @Override
    public final boolean isInvalid() {
        return this.status != 3;
    }

    void readFromChannel(boolean eof) {
        if (this.status == 1) {
            return;
        }
        ByteBuffer readBuffer = this.readBuffer.buffer();
        readBuffer.flip();
        Message<T> messageProcessor = this.ioServerConfig.getProcessor();
        while (readBuffer.hasRemaining() && this.status == 3) {
            Object dataEntry = null;
            try {
                dataEntry = this.ioServerConfig.getProtocol().decode(readBuffer, this);
            }
            catch (Exception e) {
                messageProcessor.stateEvent(this, StateMachine.DECODE_EXCEPTION, e);
                throw e;
            }
            if (dataEntry == null) break;
            try {
                messageProcessor.process(this, dataEntry);
            }
            catch (Exception e) {
                messageProcessor.stateEvent(this, StateMachine.PROCESS_EXCEPTION, e);
            }
        }
        if (eof || this.status == 2) {
            this.close(false);
            messageProcessor.stateEvent(this, StateMachine.INPUT_SHUTDOWN, null);
            return;
        }
        if (this.status == 1) {
            return;
        }
        if (readBuffer.remaining() == 0) {
            readBuffer.clear();
        } else if (readBuffer.position() > 0) {
            readBuffer.compact();
        } else {
            readBuffer.position(readBuffer.limit());
            readBuffer.limit(readBuffer.capacity());
        }
        if (!readBuffer.hasRemaining()) {
            RuntimeException exception = new RuntimeException("readBuffer has no remaining");
            messageProcessor.stateEvent(this, StateMachine.DECODE_EXCEPTION, exception);
            throw exception;
        }
        if (this.byteBuf != null && !this.byteBuf.isClosed()) {
            this.byteBuf.flush();
        }
        this.continueRead();
    }

    protected void continueRead() {
        this.readFromChannel0(this.readBuffer.buffer());
    }

    protected void continueWrite(VirtualBuffer writeBuffer) {
        this.writeToChannel0(writeBuffer.buffer());
    }

    @Override
    public final InetSocketAddress getLocalAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    @Override
    public final InetSocketAddress getRemoteAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    private void assertChannel() throws IOException {
        if (this.status == 1 || this.channel == null) {
            throw new IOException("session is closed");
        }
    }

    ServerConfig<T> getServerConfig() {
        return this.ioServerConfig;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream == null ? this.getInputStream(-1) : this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(int length) throws IOException {
        if (this.inputStream != null) {
            throw new IOException("pre inputStream has not closed");
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        TcpAioSession tcpAioSession = this;
        synchronized (tcpAioSession) {
            if (this.inputStream == null) {
                this.inputStream = new InnerInputStream(length);
            }
        }
        return this.inputStream;
    }

    private class InnerInputStream
    extends InputStream {
        private int remainLength;

        public InnerInputStream(int length) {
            this.remainLength = length >= 0 ? length : -1;
        }

        @Override
        public int read() throws IOException {
            if (this.remainLength == 0) {
                return -1;
            }
            ByteBuffer readBuffer = TcpAioSession.this.readBuffer.buffer();
            if (readBuffer.hasRemaining()) {
                --this.remainLength;
                return readBuffer.get();
            }
            readBuffer.clear();
            try {
                int readSize = TcpAioSession.this.channel.read(readBuffer).get();
                readBuffer.flip();
                if (readSize == -1) {
                    this.remainLength = 0;
                    return -1;
                }
                return this.read();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public int available() throws IOException {
            return this.remainLength == 0 ? 0 : TcpAioSession.this.readBuffer.buffer().remaining();
        }

        @Override
        public void close() throws IOException {
            if (TcpAioSession.this.inputStream == this) {
                TcpAioSession.this.inputStream = null;
            }
        }
    }
}

