/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.util.TimeZone;
import org.aoju.bus.core.date.format.FastDateFormat;

public class Fields {
    public static final String NORM_YEAR_PATTERN = "yyyy";
    public static final FastDateFormat NORM_YEAR_FORMAT = FastDateFormat.getInstance("yyyy");
    public static final String NORM_YEAR_MTOTH_PATTERN = "yyyy-MM";
    public static final FastDateFormat NORM_YEAR_MTOTH_FORMAT = FastDateFormat.getInstance("yyyy-MM");
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    public static final FastDateFormat NORM_DATE_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd");
    public static final String PURE_DATE_PATTERN = "yyyyMMdd";
    public static final FastDateFormat PURE_DATE_FORMAT = FastDateFormat.getInstance("yyyyMMdd");
    public static final String NORM_DATETIME_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final FastDateFormat NORM_DATETIME_MINUTE_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd HH:mm");
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final FastDateFormat NORM_DATETIME_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss");
    public static final String NORM_DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final FastDateFormat NORM_DATETIME_MS_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String PURE_DATETIME_PATTERN = "yyyyMMddHHmmss";
    public static final FastDateFormat PURE_DATETIME_FORMAT = FastDateFormat.getInstance("yyyyMMddHHmmss");
    public static final String PURE_DATETIME_MS_PATTERN = "yyyyMMddHHmmssSSS";
    public static final FastDateFormat PURE_DATETIME_MS_FORMAT = FastDateFormat.getInstance("yyyyMMddHHmmssSSS");
    public static final String NORM_TIME_PATTERN = "HH:mm:ss";
    public static final FastDateFormat NORM_TIME_FORMAT = FastDateFormat.getInstance("HH:mm:ss");
    public static final String PURE_TIME_PATTERN = "HHmmss";
    public static final FastDateFormat PURE_TIME_FORMAT = FastDateFormat.getInstance("HHmmss");
    public static final String PURE_TIME_MS_PATTERN = "HHmmssSSS";
    public static final FastDateFormat PURE_TIME_MS_FORMAT = FastDateFormat.getInstance("HHmmssSSS");
    public static final String HOUR_MINUTE_PATTERN = "HH:mm";
    public static final FastDateFormat HOUR_MINUTE_FORMAT = FastDateFormat.getInstance("HH:mm");
    public static final String SHORT_HOUR_MINUTE_PATTERN = "HHmm";
    public static final FastDateFormat SHORT_HOUR_MINUTE_FORMAT = FastDateFormat.getInstance("HHmm");
    public static final String MINUTE_SECOND_PATTERN = "mm:ss";
    public static final FastDateFormat MINUTE_SECOND_FORMAT = FastDateFormat.getInstance("mm:ss");
    public static final String SHORT_MINUTE_SECOND_PATTERN = "mmss";
    public static final FastDateFormat SHORT_MINUTE_SECOND_FORMAT = FastDateFormat.getInstance("mmss");
    public static final String HTTP_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final FastDateFormat HTTP_DATETIME_FORMAT = FastDateFormat.getInstance("EEE, dd MMM yyyy HH:mm:ss z");
    public static final String JDK_DATETIME_PATTERN = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static final FastDateFormat JDK_DATETIME_FORMAT = FastDateFormat.getInstance("EEE MMM dd HH:mm:ss zzz yyyy");
    public static final String NORM_DATE_CN_PATTERN = "yyyy\u5e74M\u6708d\u65e5";
    public static final FastDateFormat NORM_DATE_CN_FORMAT = FastDateFormat.getInstance("yyyy\u5e74M\u6708d\u65e5");
    public static final String ORM_MONTH_CN_PATTERN = "M\u6708d\u65e5";
    public static final FastDateFormat NORM_MONTH_CN_FORMAT = FastDateFormat.getInstance("M\u6708d\u65e5");
    public static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final FastDateFormat UTC_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss'Z'", TimeZone.getTimeZone("UTC"));
    public static final String MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final FastDateFormat MSEC_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZ", TimeZone.getTimeZone("UTC"));
    public static final String SPACEY_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    public static final FastDateFormat SPACEY_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss Z", TimeZone.getTimeZone("UTC"));
    public static final String SPACEY_MSEC_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    public static final FastDateFormat SPACEY_MSEC_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss.SSS Z", TimeZone.getTimeZone("UTC"));
    public static final String OUTPUT_MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final FastDateFormat OUTPUT_MSEC_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", TimeZone.getTimeZone("UTC"));
    public static final String[] ZODIAC = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};
    public static final String[] CHINESE_ZODIAC = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    public static final int[] ZODIAC_SLICED = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};

    public static enum Level {
        DAY("\u5929"),
        HOUR("\u5c0f\u65f6"),
        MINUTE("\u5206"),
        SECOND("\u79d2"),
        MILLSECOND("\u6beb\u79d2");

        public String name;

        private Level(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Week {
        SUNDAY(1),
        MONDAY(2),
        TUESDAY(3),
        WEDNESDAY(4),
        THURSDAY(5),
        FRIDAY(6),
        SATURDAY(7);

        private int value;

        private Week(int value) {
            this.value = value;
        }

        public static Week of(int calendarWeekIntValue) {
            switch (calendarWeekIntValue) {
                case 1: {
                    return SUNDAY;
                }
                case 2: {
                    return MONDAY;
                }
                case 3: {
                    return TUESDAY;
                }
                case 4: {
                    return WEDNESDAY;
                }
                case 5: {
                    return THURSDAY;
                }
                case 6: {
                    return FRIDAY;
                }
                case 7: {
                    return SATURDAY;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }

        public String toChinese() {
            return this.toChinese("\u661f\u671f");
        }

        public String toChinese(String weekNamePre) {
            switch (this) {
                case SUNDAY: {
                    return weekNamePre + "\u65e5";
                }
                case MONDAY: {
                    return weekNamePre + "\u4e00";
                }
                case TUESDAY: {
                    return weekNamePre + "\u4e8c";
                }
                case WEDNESDAY: {
                    return weekNamePre + "\u4e09";
                }
                case THURSDAY: {
                    return weekNamePre + "\u56db";
                }
                case FRIDAY: {
                    return weekNamePre + "\u4e94";
                }
                case SATURDAY: {
                    return weekNamePre + "\u516d";
                }
            }
            return null;
        }
    }

    public static enum Quarter {
        Q1(1),
        Q2(2),
        Q3(3),
        Q4(4);

        private int value;

        private Quarter(int value) {
            this.value = value;
        }

        public static Quarter of(int intValue) {
            switch (intValue) {
                case 1: {
                    return Q1;
                }
                case 2: {
                    return Q2;
                }
                case 3: {
                    return Q3;
                }
                case 4: {
                    return Q4;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Month {
        JANUARY(0),
        FEBRUARY(1),
        MARCH(2),
        APRIL(3),
        MAY(4),
        JUNE(5),
        JULY(6),
        AUGUST(7),
        SEPTEMBER(8),
        OCTOBER(9),
        NOVEMBER(10),
        DECEMBER(11),
        UNDECIMBER(12);

        private int value;

        private Month(int value) {
            this.value = value;
        }

        public static Month of(int calendarMonthIntValue) {
            switch (calendarMonthIntValue) {
                case 0: {
                    return JANUARY;
                }
                case 1: {
                    return FEBRUARY;
                }
                case 2: {
                    return MARCH;
                }
                case 3: {
                    return APRIL;
                }
                case 4: {
                    return MAY;
                }
                case 5: {
                    return JUNE;
                }
                case 6: {
                    return JULY;
                }
                case 7: {
                    return AUGUST;
                }
                case 8: {
                    return SEPTEMBER;
                }
                case 9: {
                    return OCTOBER;
                }
                case 10: {
                    return NOVEMBER;
                }
                case 11: {
                    return DECEMBER;
                }
                case 12: {
                    return UNDECIMBER;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Unit {
        MS(1L),
        SECOND(1000L),
        MINUTE(SECOND.getMillis() * 60L),
        HOUR(MINUTE.getMillis() * 60L),
        DAY(HOUR.getMillis() * 24L),
        WEEK(DAY.getMillis() * 7L);

        private long millis;

        private Unit(long millis) {
            this.millis = millis;
        }

        public long getMillis() {
            return this.millis;
        }
    }

    public static enum DateField {
        YEAR(1),
        MONTH(2),
        WEEK_OF_YEAR(3),
        WEEK_OF_MONTH(4),
        DAY_OF_MONTH(5),
        DAY_OF_YEAR(6),
        DAY_OF_WEEK(7),
        DAY_OF_WEEK_IN_MONTH(8),
        AM_PM(9),
        HOUR(10),
        HOUR_OF_DAY(11),
        MINUTE(12),
        SECOND(13),
        MILLISECOND(14);

        private int value;

        private DateField(int value) {
            this.value = value;
        }

        public static DateField of(int calendarPartIntValue) {
            switch (calendarPartIntValue) {
                case 1: {
                    return YEAR;
                }
                case 2: {
                    return MONTH;
                }
                case 3: {
                    return WEEK_OF_YEAR;
                }
                case 4: {
                    return WEEK_OF_MONTH;
                }
                case 5: {
                    return DAY_OF_MONTH;
                }
                case 6: {
                    return DAY_OF_YEAR;
                }
                case 7: {
                    return DAY_OF_WEEK;
                }
                case 8: {
                    return DAY_OF_WEEK_IN_MONTH;
                }
                case 12: {
                    return MINUTE;
                }
                case 13: {
                    return SECOND;
                }
                case 14: {
                    return MILLISECOND;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }
}

