/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.locale;

import org.aoju.bus.extra.locale.BIG5;
import org.aoju.bus.extra.locale.Big5S;
import org.aoju.bus.extra.locale.CP1252;
import org.aoju.bus.extra.locale.EUC;
import org.aoju.bus.extra.locale.EUCJP;
import org.aoju.bus.extra.locale.EUCJPS;
import org.aoju.bus.extra.locale.EUCKR;
import org.aoju.bus.extra.locale.EUCKRS;
import org.aoju.bus.extra.locale.EUCTW;
import org.aoju.bus.extra.locale.EUCTWS;
import org.aoju.bus.extra.locale.GB18030;
import org.aoju.bus.extra.locale.GB2312;
import org.aoju.bus.extra.locale.GB2312S;
import org.aoju.bus.extra.locale.HZ;
import org.aoju.bus.extra.locale.ISO2022CN;
import org.aoju.bus.extra.locale.ISO2022JP;
import org.aoju.bus.extra.locale.ISO2022KR;
import org.aoju.bus.extra.locale.SJIS;
import org.aoju.bus.extra.locale.Score;
import org.aoju.bus.extra.locale.UCS2BE;
import org.aoju.bus.extra.locale.UCS2LE;
import org.aoju.bus.extra.locale.UTF8;
import org.aoju.bus.extra.locale.Verifier;

public abstract class PSM {
    public static final int ALL = 0;
    public static final int JAPANESE = 1;
    public static final int CHINESE = 2;
    public static final int SIMPLIFIED_CHINESE = 3;
    public static final int TRADITIONAL_CHINESE = 4;
    public static final int KOREAN = 5;
    public static final int NO_OF_LANGUAGES = 6;
    public static final int MAX_VERIFIERS = 16;
    Verifier[] mVerifier;
    Score[] mStatisticsData;
    EUC msampler = new EUC();
    byte[] mState = new byte[16];
    int[] mItemIdx = new int[16];
    int mItems;
    int mClassItems;
    boolean mDone;
    boolean mRunsampler;
    boolean mClassRunsampler;

    public PSM() {
        this.initVerifiers(0);
        this.reset();
    }

    public PSM(int langFlag) {
        this.initVerifiers(langFlag);
        this.reset();
    }

    public PSM(int aItems, Verifier[] aVerifierSet, Score[] aStatisticsSet) {
        this.mClassRunsampler = aStatisticsSet != null;
        this.mStatisticsData = aStatisticsSet;
        this.mVerifier = aVerifierSet;
        this.mClassItems = aItems;
        this.reset();
    }

    public void reset() {
        this.mRunsampler = this.mClassRunsampler;
        this.mDone = false;
        this.mItems = this.mClassItems;
        for (int i = 0; i < this.mItems; ++i) {
            this.mState[i] = 0;
            this.mItemIdx[i] = i;
        }
        this.msampler.reset();
    }

    protected void initVerifiers(int currVerSet) {
        boolean idx = false;
        int currVerifierSet = currVerSet >= 0 && currVerSet < 6 ? currVerSet : 0;
        this.mVerifier = null;
        this.mStatisticsData = null;
        if (currVerifierSet == 4) {
            this.mVerifier = new Verifier[]{new UTF8(), new BIG5(), new ISO2022CN(), new EUCTW(), new CP1252(), new UCS2BE(), new UCS2LE()};
            this.mStatisticsData = new Score[]{null, new Big5S(), null, new EUCTWS(), null, null, null};
        } else if (currVerifierSet == 5) {
            this.mVerifier = new Verifier[]{new UTF8(), new EUCKR(), new ISO2022KR(), new CP1252(), new UCS2BE(), new UCS2LE()};
        } else if (currVerifierSet == 3) {
            this.mVerifier = new Verifier[]{new UTF8(), new GB2312(), new GB18030(), new ISO2022CN(), new HZ(), new CP1252(), new UCS2BE(), new UCS2LE()};
        } else if (currVerifierSet == 1) {
            this.mVerifier = new Verifier[]{new UTF8(), new SJIS(), new EUCJP(), new ISO2022JP(), new CP1252(), new UCS2BE(), new UCS2LE()};
        } else if (currVerifierSet == 2) {
            this.mVerifier = new Verifier[]{new UTF8(), new GB2312(), new GB18030(), new BIG5(), new ISO2022CN(), new HZ(), new EUCTW(), new CP1252(), new UCS2BE(), new UCS2LE()};
            this.mStatisticsData = new Score[]{null, new GB2312S(), null, new Big5S(), null, null, new EUCTWS(), null, null, null};
        } else if (currVerifierSet == 0) {
            this.mVerifier = new Verifier[]{new UTF8(), new SJIS(), new EUCJP(), new ISO2022JP(), new EUCKR(), new ISO2022KR(), new BIG5(), new EUCTW(), new GB2312(), new GB18030(), new ISO2022CN(), new HZ(), new CP1252(), new UCS2BE(), new UCS2LE()};
            this.mStatisticsData = new Score[]{null, null, new EUCJPS(), null, new EUCKRS(), null, new Big5S(), new EUCTWS(), new GB2312S(), null, null, null, null, null, null};
        }
        this.mClassRunsampler = this.mStatisticsData != null;
        this.mClassItems = this.mVerifier.length;
    }

    public abstract void report(String var1);

    public boolean handleData(byte[] aBuf, int len) {
        for (int i = 0; i < len; ++i) {
            byte b = aBuf[i];
            int j = 0;
            while (j < this.mItems) {
                byte st = Verifier.getNextState(this.mVerifier[this.mItemIdx[j]], b, this.mState[j]);
                if (st == 2) {
                    this.report(this.mVerifier[this.mItemIdx[j]].charset());
                    this.mDone = true;
                    return this.mDone;
                }
                if (st == 1) {
                    --this.mItems;
                    if (j >= this.mItems) continue;
                    this.mItemIdx[j] = this.mItemIdx[this.mItems];
                    this.mState[j] = this.mState[this.mItems];
                    continue;
                }
                this.mState[j++] = st;
            }
            if (this.mItems <= 1) {
                if (1 == this.mItems) {
                    this.report(this.mVerifier[this.mItemIdx[0]].charset());
                }
                this.mDone = true;
                return this.mDone;
            }
            int nonUCS2Num = 0;
            int nonUCS2Idx = 0;
            for (j = 0; j < this.mItems; ++j) {
                if (this.mVerifier[this.mItemIdx[j]].isUCS2() || this.mVerifier[this.mItemIdx[j]].isUCS2()) continue;
                ++nonUCS2Num;
                nonUCS2Idx = j;
            }
            if (true != nonUCS2Num) continue;
            this.report(this.mVerifier[this.mItemIdx[nonUCS2Idx]].charset());
            this.mDone = true;
            return this.mDone;
        }
        if (this.mRunsampler) {
            this.sample(aBuf, len);
        }
        return this.mDone;
    }

    public void DataEnd() {
        if (this.mDone) {
            return;
        }
        if (this.mItems == 2) {
            if (this.mVerifier[this.mItemIdx[0]].charset().equals("GB18030")) {
                this.report(this.mVerifier[this.mItemIdx[1]].charset());
                this.mDone = true;
            } else if (this.mVerifier[this.mItemIdx[1]].charset().equals("GB18030")) {
                this.report(this.mVerifier[this.mItemIdx[0]].charset());
                this.mDone = true;
            }
        }
        if (this.mRunsampler) {
            this.sample(null, 0, true);
        }
    }

    public void sample(byte[] aBuf, int aLen) {
        this.sample(aBuf, aLen, false);
    }

    public void sample(byte[] aBuf, int aLen, boolean aLastChance) {
        int j;
        int possibleCandidateNum = 0;
        int eucNum = 0;
        for (j = 0; j < this.mItems; ++j) {
            if (null != this.mStatisticsData[this.mItemIdx[j]]) {
                ++eucNum;
            }
            if (this.mVerifier[this.mItemIdx[j]].isUCS2() || this.mVerifier[this.mItemIdx[j]].charset().equals("GB18030")) continue;
            ++possibleCandidateNum;
        }
        boolean bl = this.mRunsampler = eucNum > 1;
        if (this.mRunsampler) {
            this.mRunsampler = this.msampler.sample(aBuf, aLen);
            if ((aLastChance && this.msampler.getSomeData() || this.msampler.enoughData()) && eucNum == possibleCandidateNum) {
                this.msampler.calFreq();
                int bestIdx = -1;
                int eucCnt = 0;
                float bestScore = 0.0f;
                for (j = 0; j < this.mItems; ++j) {
                    if (null == this.mStatisticsData[this.mItemIdx[j]] || this.mVerifier[this.mItemIdx[j]].charset().equals("Big5")) continue;
                    float score = this.msampler.getScore(this.mStatisticsData[this.mItemIdx[j]].mFirstByteFreq(), this.mStatisticsData[this.mItemIdx[j]].mFirstByteWeight(), this.mStatisticsData[this.mItemIdx[j]].mSecondByteFreq(), this.mStatisticsData[this.mItemIdx[j]].mSecondByteWeight());
                    if (0 != eucCnt++ && !(bestScore > score)) continue;
                    bestScore = score;
                    bestIdx = j;
                }
                if (bestIdx >= 0) {
                    this.report(this.mVerifier[this.mItemIdx[bestIdx]].charset());
                    this.mDone = true;
                }
            }
        }
    }

    public String[] getProbableCharsets() {
        if (this.mItems <= 0) {
            String[] nomatch = new String[]{"nomatch"};
            return nomatch;
        }
        String[] ret = new String[this.mItems];
        for (int i = 0; i < this.mItems; ++i) {
            ret[i] = this.mVerifier[this.mItemIdx[i]].charset();
        }
        return ret;
    }
}

