/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware;

import java.util.function.Supplier;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.hardware.CentralProcessor;
import org.aoju.bus.health.hardware.ComputerSystem;
import org.aoju.bus.health.hardware.GlobalMemory;
import org.aoju.bus.health.hardware.HardwareLayer;
import org.aoju.bus.health.hardware.Sensors;

public abstract class AbstractHardwareLayer
implements HardwareLayer {
    private final Supplier<ComputerSystem> computerSystem = Memoizer.memoize(this::createComputerSystem);
    private final Supplier<CentralProcessor> processor = Memoizer.memoize(this::createProcessor);
    private final Supplier<GlobalMemory> memory = Memoizer.memoize(this::createMemory);
    private final Supplier<Sensors> sensors = Memoizer.memoize(this::createSensors);

    @Override
    public ComputerSystem getComputerSystem() {
        return this.computerSystem.get();
    }

    protected abstract ComputerSystem createComputerSystem();

    @Override
    public CentralProcessor getProcessor() {
        return this.processor.get();
    }

    protected abstract CentralProcessor createProcessor();

    @Override
    public GlobalMemory getMemory() {
        return this.memory.get();
    }

    protected abstract GlobalMemory createMemory();

    @Override
    public Sensors getSensors() {
        return this.sensors.get();
    }

    protected abstract Sensors createSensors();
}

