/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.software.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import org.aoju.bus.logger.Logger;

public class SystemInfo {
    private WinBase.SYSTEM_INFO systemInfo = null;

    public SystemInfo() {
        this.init();
    }

    public SystemInfo(WinBase.SYSTEM_INFO si) {
        this.systemInfo = si;
    }

    private void init() {
        WinBase.SYSTEM_INFO si = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(si);
        try {
            IntByReference isWow64 = new IntByReference();
            WinNT.HANDLE hProcess = Kernel32.INSTANCE.GetCurrentProcess();
            if (Kernel32.INSTANCE.IsWow64Process(hProcess, isWow64) && isWow64.getValue() > 0) {
                Kernel32.INSTANCE.GetNativeSystemInfo(si);
            }
        }
        catch (UnsatisfiedLinkError e) {
            Logger.trace("No WOW64 support: {}", e);
        }
        this.systemInfo = si;
        Logger.debug("Initialized OSNativeSystemInfo", new Object[0]);
    }

    public int getNumberOfProcessors() {
        return this.systemInfo.dwNumberOfProcessors.intValue();
    }
}

