/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.magic;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.io.segment.BufferSink;
import org.aoju.bus.core.io.segment.Source;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.bodys.MultipartBody;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.magic.AbsCallback;
import org.aoju.bus.http.magic.PostRequest;
import org.aoju.bus.http.magic.RequestCall;

public abstract class HttpRequest {
    protected int id;
    protected String url;
    protected Map<String, String> params;
    protected Map<String, String> encodedParams;
    protected Map<String, String> headers;
    protected String body;
    protected List<PostRequest.FileInfo> fileInfos;
    protected MultipartBody multipartBody;
    protected Request.Builder builder = new Request.Builder();

    protected HttpRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<PostRequest.FileInfo> fileInfos, String body, MultipartBody multipartBody, int id) {
        this(url, tag, params, null, headers, fileInfos, body, multipartBody, id);
    }

    protected HttpRequest(String url, Object tag, Map<String, String> params, Map<String, String> encodedParams, Map<String, String> headers, List<PostRequest.FileInfo> fileInfos, String body, MultipartBody multipartBody, int id) {
        this.url = url;
        this.params = params;
        this.encodedParams = encodedParams;
        this.headers = headers;
        this.fileInfos = fileInfos;
        this.body = body;
        this.multipartBody = multipartBody;
        this.id = id;
        if (url == null) {
            throw new IllegalArgumentException("url can not be null.");
        }
        this.builder.url(url).tag(tag);
        this.appendHeaders();
    }

    public static RequestBody createRequestBody(final MediaType contentType, final InputStream is) {
        if (is == null) {
            throw new NullPointerException("is == null");
        }
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() {
                try {
                    return is.available();
                }
                catch (IOException e) {
                    return 0L;
                }
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                Source source = null;
                try {
                    source = IoUtils.source(is);
                    sink.writeAll(source);
                }
                finally {
                    IoUtils.close(source);
                }
            }
        };
    }

    protected abstract RequestBody buildRequestBody();

    protected abstract Request buildRequest(RequestBody var1);

    public RequestCall build(Httpd httpd) {
        return new RequestCall(this, httpd);
    }

    public Request createRequest(AbsCallback absCallback) {
        return this.buildRequest(this.buildRequestBody());
    }

    protected void appendHeaders() {
        Headers.Builder headerBuilder = new Headers.Builder();
        if (this.headers == null || this.headers.isEmpty()) {
            return;
        }
        for (String key : this.headers.keySet()) {
            headerBuilder.add(key, this.headers.get(key));
        }
        this.builder.headers(headerBuilder.build());
    }

    public int getId() {
        return this.id;
    }
}

