/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.StringUtils;

public class Base64Decoder {
    public static String decodeStr(String source) {
        return Base64Decoder.decodeStr(source, Charset.UTF_8);
    }

    public static String decodeStr(String source, String charset) {
        return StringUtils.str(Base64Decoder.decode(source, charset), charset);
    }

    public static String decodeStr(String source, java.nio.charset.Charset charset) {
        return StringUtils.str(Base64Decoder.decode(source, charset), charset);
    }

    public static byte[] decode(String source) {
        return Base64Decoder.decode(source, Charset.UTF_8);
    }

    public static byte[] decode(String source, String charset) {
        return Base64Decoder.decode(StringUtils.bytes((CharSequence)source, charset));
    }

    public static byte[] decode(String source, java.nio.charset.Charset charset) {
        return Base64Decoder.decode(StringUtils.bytes((CharSequence)source, charset));
    }

    public static byte[] decode(byte[] in) {
        if (ArrayUtils.isEmpty(in)) {
            return in;
        }
        return Base64Decoder.decode(in, 0, in.length);
    }

    public static byte[] decode(byte[] in, int pos, int length) {
        if (ArrayUtils.isEmpty(in)) {
            return in;
        }
        IntWrapper offset = new IntWrapper(pos);
        int maxPos = pos + length - 1;
        int octetId = 0;
        byte[] octet = new byte[length * 3 / 4];
        while (offset.value <= maxPos) {
            byte sestet0 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet1 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet2 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet3 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            if (-2 != sestet1) {
                octet[octetId++] = (byte)(sestet0 << 2 | sestet1 >>> 4);
            }
            if (-2 != sestet2) {
                octet[octetId++] = (byte)((sestet1 & 0xF) << 4 | sestet2 >>> 2);
            }
            if (-2 == sestet3) continue;
            octet[octetId++] = (byte)((sestet2 & 3) << 6 | sestet3);
        }
        if (octetId == octet.length) {
            return octet;
        }
        return (byte[])ArrayUtils.copy(octet, new byte[octetId], octetId);
    }

    private static byte getNextValidDecodeByte(byte[] in, IntWrapper pos, int maxPos) {
        while (pos.value <= maxPos) {
            byte decodeByte;
            byte base64Byte;
            if ((base64Byte = in[pos.value++]) <= -1 || (decodeByte = Normal.STANDARD_DECODE_TABLE[base64Byte]) <= -1) continue;
            return decodeByte;
        }
        return -2;
    }

    private static class IntWrapper {
        int value;

        IntWrapper(int value) {
            this.value = value;
        }
    }
}

