/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.health.Command;
import org.aoju.bus.logger.Logger;

public class Builder {
    public static final String HEX_ERROR = "0x%08X";
    public static final String UNKNOWN = "unknown";
    public static final String SYSFS_SERIAL_PATH = "/sys/devices/virtual/dmi/id/";
    public static final OffsetDateTime UNIX_EPOCH = OffsetDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
    public static final Pattern whitespacesColonWhitespace = Pattern.compile("\\s+:\\s");
    public static final Pattern whitespaces = Pattern.compile("\\s+");
    public static final Pattern notDigits = Pattern.compile("[^0-9]+");
    public static final Pattern startWithNotDigits = Pattern.compile("^[^0-9]*");
    private static final long KIBI = 1024L;
    private static final long MEBI = 0x100000L;
    private static final long GIBI = 0x40000000L;
    private static final long TEBI = 0x10000000000L;
    private static final long PEBI = 0x4000000000000L;
    private static final long EXBI = 0x1000000000000000L;
    private static final long KILO = 1000L;
    private static final long MEGA = 1000000L;
    private static final long GIGA = 1000000000L;
    private static final long TERA = 1000000000000L;
    private static final long PETA = 1000000000000000L;
    private static final long EXA = 1000000000000000000L;
    private static final BigInteger TWOS_COMPLEMENT_REF = BigInteger.ONE.shiftLeft(64);
    private static final String DEFAULT_Logger_MSG = "{} didn't parse. Returning default. {}";
    private static final Pattern HERTZ_PATTERN = Pattern.compile("(\\d+(.\\d+)?) ?([kMGT]?Hz).*");
    private static final Pattern VALID_HEX = Pattern.compile("[0-9a-fA-F]+");
    private static final Pattern DHMS = Pattern.compile("(?:(\\d+)-)?(?:(\\d+):)??(?:(\\d+):)?(\\d+)(?:\\.(\\d+))?");
    private static final Pattern UUID_PATTERN = Pattern.compile(".*([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}).*");
    private static final String HZ = "Hz";
    private static final String KHZ = "kHz";
    private static final String MHZ = "MHz";
    private static final String GHZ = "GHz";
    private static final String THZ = "THz";
    private static final String PHZ = "PHz";
    private static final Map<String, Long> multipliers;
    private static final long EPOCH_DIFF = 11644473600000L;
    private static final int TZ_OFFSET;
    private static final long[] POWERS_OF_TEN;
    private static final char[] HEX_ARRAY;
    private static final DateTimeFormatter CIM_FORMAT;

    private Builder() {
        throw new AssertionError();
    }

    public static String formatBytes(long bytes) {
        if (bytes == 1L) {
            return String.format("%d byte", bytes);
        }
        if (bytes < 1024L) {
            return String.format("%d bytes", bytes);
        }
        if (bytes < 0x100000L) {
            return Builder.formatUnits(bytes, 1024L, "KiB");
        }
        if (bytes < 0x40000000L) {
            return Builder.formatUnits(bytes, 0x100000L, "MiB");
        }
        if (bytes < 0x10000000000L) {
            return Builder.formatUnits(bytes, 0x40000000L, "GiB");
        }
        if (bytes < 0x4000000000000L) {
            return Builder.formatUnits(bytes, 0x10000000000L, "TiB");
        }
        if (bytes < 0x1000000000000000L) {
            return Builder.formatUnits(bytes, 0x4000000000000L, "PiB");
        }
        return Builder.formatUnits(bytes, 0x1000000000000000L, "EiB");
    }

    private static String formatUnits(long value, long prefix, String unit) {
        if (value % prefix == 0L) {
            return String.format("%d %s", value / prefix, unit);
        }
        return String.format("%.1f %s", (double)value / (double)prefix, unit);
    }

    public static String formatBytesDecimal(long bytes) {
        if (bytes == 1L) {
            return String.format("%d byte", bytes);
        }
        if (bytes < 1000L) {
            return String.format("%d bytes", bytes);
        }
        return Builder.formatValue(bytes, "B");
    }

    public static String formatHertz(long hertz) {
        return Builder.formatValue(hertz, HZ);
    }

    public static String formatValue(long value, String unit) {
        if (value < 1000L) {
            return String.format("%d %s", value, unit);
        }
        if (value < 1000000L) {
            return Builder.formatUnits(value, 1000L, "K" + unit);
        }
        if (value < 1000000000L) {
            return Builder.formatUnits(value, 1000000L, "M" + unit);
        }
        if (value < 1000000000000L) {
            return Builder.formatUnits(value, 1000000000L, "G" + unit);
        }
        if (value < 1000000000000000L) {
            return Builder.formatUnits(value, 1000000000000L, "T" + unit);
        }
        if (value < 1000000000000000000L) {
            return Builder.formatUnits(value, 1000000000000000L, "P" + unit);
        }
        return Builder.formatUnits(value, 1000000000000000000L, "E" + unit);
    }

    public static String formatElapsedSecs(long secs) {
        long eTime = secs;
        long days = TimeUnit.SECONDS.toDays(eTime);
        long hr = TimeUnit.SECONDS.toHours(eTime -= TimeUnit.DAYS.toSeconds(days));
        long min = TimeUnit.SECONDS.toMinutes(eTime -= TimeUnit.HOURS.toSeconds(hr));
        long sec = eTime -= TimeUnit.MINUTES.toSeconds(min);
        return String.format("%d days, %02d:%02d:%02d", days, hr, min, sec);
    }

    public static float round(float d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Float.toString(d)).setScale(decimalPlace, RoundingMode.HALF_UP);
        return bd.floatValue();
    }

    public static long getUnsignedInt(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static String toUnsignedString(int i) {
        if (i >= 0) {
            return Integer.toString(i);
        }
        return Long.toString(Builder.getUnsignedInt(i));
    }

    public static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return BigInteger.valueOf(l).add(TWOS_COMPLEMENT_REF).toString();
    }

    public static String formatError(int errorCode) {
        return String.format(HEX_ERROR, errorCode);
    }

    public static Map<Integer, String> getCwdMap(int pid) {
        List<String> lsof = Command.runNative("lsof -Fn -d cwd" + (pid < 0 ? "" : " -p " + pid));
        HashMap<Integer, String> cwdMap = new HashMap<Integer, String>();
        Integer key = -1;
        for (String line : lsof) {
            if (line.isEmpty()) continue;
            switch (line.charAt(0)) {
                case 'p': {
                    key = Builder.parseIntOrDefault(line.substring(1), -1);
                    break;
                }
                case 'n': {
                    cwdMap.put(key, line.substring(1));
                    break;
                }
            }
        }
        return cwdMap;
    }

    public static long parseHertz(String hertz) {
        double value;
        Matcher matcher = HERTZ_PATTERN.matcher(hertz.trim());
        if (matcher.find() && matcher.groupCount() == 3 && (value = Double.valueOf(matcher.group(1)) * (double)multipliers.getOrDefault(matcher.group(3), -1L).longValue()) >= 0.0) {
            return (long)value;
        }
        return -1L;
    }

    public static int parseLastInt(String s, int i) {
        try {
            String ls = Builder.parseLastString(s);
            if (ls.toLowerCase().startsWith("0x")) {
                return Integer.decode(ls);
            }
            return Integer.parseInt(ls);
        }
        catch (NumberFormatException e) {
            Logger.trace(DEFAULT_Logger_MSG, s, e);
            return i;
        }
    }

    public static long parseLastLong(String s, long li) {
        try {
            String ls = Builder.parseLastString(s);
            if (ls.toLowerCase().startsWith("0x")) {
                return Long.decode(ls);
            }
            return Long.parseLong(ls);
        }
        catch (NumberFormatException e) {
            Logger.trace(DEFAULT_Logger_MSG, s, e);
            return li;
        }
    }

    public static double parseLastDouble(String s, double d) {
        try {
            return Double.parseDouble(Builder.parseLastString(s));
        }
        catch (NumberFormatException e) {
            Logger.trace(DEFAULT_Logger_MSG, s, e);
            return d;
        }
    }

    public static String parseLastString(String s) {
        String[] ss = whitespaces.split(s);
        if (ss.length < 1) {
            return s;
        }
        return ss[ss.length - 1];
    }

    public static String byteArrayToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexStringToByteArray(String digits) {
        int len = digits.length();
        if (!VALID_HEX.matcher(digits).matches() || (len & 1) != 0) {
            Logger.warn("Invalid hexadecimal string: {}", digits);
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)(Character.digit(digits.charAt(i), 16) << 4 | Character.digit(digits.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] asciiStringToByteArray(String text, int length) {
        return Arrays.copyOf(text.getBytes(StandardCharsets.US_ASCII), length);
    }

    public static byte[] longToByteArray(long value, int valueSize, int length) {
        long val = value;
        byte[] b = new byte[8];
        for (int i = 7; i >= 0 && val != 0L; val >>>= 8, --i) {
            b[i] = (byte)val;
        }
        return Arrays.copyOfRange(b, 8 - valueSize, 8 + length - valueSize);
    }

    public static long strToLong(String str, int size) {
        return Builder.byteArrayToLong(str.getBytes(StandardCharsets.US_ASCII), size);
    }

    public static long byteArrayToLong(byte[] bytes, int size) {
        if (size > 8) {
            throw new IllegalArgumentException("Can't convert more than 8 bytes.");
        }
        if (size > bytes.length) {
            throw new IllegalArgumentException("Size can't be larger than array length.");
        }
        long total = 0L;
        for (int i = 0; i < size; ++i) {
            total = total << 8 | (long)(bytes[i] & 0xFF);
        }
        return total;
    }

    public static float byteArrayToFloat(byte[] bytes, int size, int fpBits) {
        return (float)Builder.byteArrayToLong(bytes, size) / (float)(1 << fpBits);
    }

    public static long unsignedIntToLong(int unsignedValue) {
        long longValue = unsignedValue;
        return longValue & 0xFFFFFFFFL;
    }

    public static long unsignedLongToSignedLong(long unsignedValue) {
        return unsignedValue & Long.MAX_VALUE;
    }

    public static String hexStringToString(String hexString) {
        if (hexString.length() % 2 > 0) {
            return hexString;
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (int pos = 0; pos < hexString.length(); pos += 2) {
                int charAsInt = Integer.parseInt(hexString.substring(pos, pos + 2), 16);
                if (charAsInt < 32 || charAsInt > 127) {
                    return hexString;
                }
                sb.append((char)charAsInt);
            }
        }
        catch (NumberFormatException e) {
            Logger.trace(DEFAULT_Logger_MSG, hexString, e);
            return hexString;
        }
        return sb.toString();
    }

    public static int parseIntOrDefault(String s, int defaultInt) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            Logger.trace(DEFAULT_Logger_MSG, s, e);
            return defaultInt;
        }
    }

    public static long parseLongOrDefault(String s, long defaultLong) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            Logger.trace(DEFAULT_Logger_MSG, s, e);
            return defaultLong;
        }
    }

    public static long parseUnsignedLongOrDefault(String s, long defaultLong) {
        try {
            return new BigInteger(s).longValue();
        }
        catch (NumberFormatException e) {
            Logger.trace(DEFAULT_Logger_MSG, s, e);
            return defaultLong;
        }
    }

    public static double parseDoubleOrDefault(String s, double defaultDouble) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            Logger.trace(DEFAULT_Logger_MSG, s, e);
            return defaultDouble;
        }
    }

    public static long parseDHMSOrDefault(String s, long defaultLong) {
        Matcher m = DHMS.matcher(s);
        if (m.matches()) {
            long milliseconds = 0L;
            if (m.group(1) != null) {
                milliseconds += Builder.parseLongOrDefault(m.group(1), 0L) * 86400000L;
            }
            if (m.group(2) != null) {
                milliseconds += Builder.parseLongOrDefault(m.group(2), 0L) * 3600000L;
            }
            if (m.group(3) != null) {
                milliseconds += Builder.parseLongOrDefault(m.group(3), 0L) * 60000L;
            }
            milliseconds += Builder.parseLongOrDefault(m.group(4), 0L) * 1000L;
            return milliseconds += (long)(1000.0 * Builder.parseDoubleOrDefault("0." + m.group(5), 0.0));
        }
        return defaultLong;
    }

    public static String parseUuidOrDefault(String s, String defaultStr) {
        Matcher m = UUID_PATTERN.matcher(s.toLowerCase());
        if (m.matches()) {
            return m.group(1);
        }
        return defaultStr;
    }

    public static String getSingleQuoteStringValue(String line) {
        return Builder.getStringBetween(line, '\'');
    }

    public static String getDoubleQuoteStringValue(String line) {
        return Builder.getStringBetween(line, '\"');
    }

    public static String getStringBetween(String line, char c) {
        int firstOcc = line.indexOf(c);
        if (firstOcc < 0) {
            return "";
        }
        return line.substring(firstOcc + 1, line.lastIndexOf(c)).trim();
    }

    public static int getFirstIntValue(String line) {
        return Builder.getNthIntValue(line, 1);
    }

    public static int getNthIntValue(String line, int n) {
        String[] split = notDigits.split(startWithNotDigits.matcher(line).replaceFirst(""));
        if (split.length >= n) {
            return Builder.parseIntOrDefault(split[n - 1], 0);
        }
        return 0;
    }

    public static String removeMatchingString(String original, String toRemove) {
        if (original == null || original.isEmpty() || toRemove == null || toRemove.isEmpty()) {
            return original;
        }
        int matchIndex = original.indexOf(toRemove, 0);
        if (matchIndex == -1) {
            return original;
        }
        StringBuilder buffer = new StringBuilder(original.length() - toRemove.length());
        int currIndex = 0;
        do {
            buffer.append(original.substring(currIndex, matchIndex));
        } while ((matchIndex = original.indexOf(toRemove, currIndex = matchIndex + toRemove.length())) != -1);
        buffer.append(original.substring(currIndex));
        return buffer.toString();
    }

    public static long[] parseStringToLongArray(String s, int[] indices, int length, char delimiter) {
        long[] parsed = new long[indices.length];
        int charIndex = s.length();
        int parsedIndex = indices.length - 1;
        int stringIndex = length - 1;
        int power = 0;
        boolean delimCurrent = false;
        while (--charIndex > 0 && parsedIndex >= 0) {
            char c = s.charAt(charIndex);
            if (c == delimiter) {
                if (delimCurrent) continue;
                power = 0;
                if (indices[parsedIndex] == stringIndex--) {
                    --parsedIndex;
                }
                delimCurrent = true;
                continue;
            }
            if (indices[parsedIndex] != stringIndex || c == '+') {
                delimCurrent = false;
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (power > 18) {
                    Logger.error("Number is too big for a long parsing string '{}' to long array", s);
                    return new long[indices.length];
                }
                int n = parsedIndex;
                parsed[n] = parsed[n] + (long)(c - 48) * POWERS_OF_TEN[power++];
                delimCurrent = false;
                continue;
            }
            if (c == '-') {
                int n = parsedIndex;
                parsed[n] = parsed[n] * -1L;
                delimCurrent = false;
                continue;
            }
            Logger.error("Illegal character parsing string '{}' to long array: {}", s, Character.valueOf(s.charAt(charIndex)));
            return new long[indices.length];
        }
        if (parsedIndex > 0) {
            Logger.error("Not enough fields in string '{}' parsing to long array: {}", s, indices.length - parsedIndex);
            return new long[indices.length];
        }
        return parsed;
    }

    public static int countStringToLongArray(String s, char delimiter) {
        int charIndex = s.length();
        int numbers = 0;
        boolean delimCurrent = false;
        while (--charIndex > 0) {
            char c = s.charAt(charIndex);
            if (c == delimiter) {
                if (delimCurrent) continue;
                ++numbers;
                delimCurrent = true;
                continue;
            }
            if (c >= '0' && c <= '9' || c == '-' || c == '+') {
                delimCurrent = false;
                continue;
            }
            return numbers;
        }
        return numbers + 1;
    }

    public static String getTextBetweenStrings(String text, String before, String after) {
        String result = "";
        if (text.indexOf(before) >= 0 && text.indexOf(after) >= 0) {
            result = text.substring(text.indexOf(before) + before.length(), text.length());
            result = result.substring(0, result.indexOf(after));
        }
        return result;
    }

    public static long filetimeToUtcMs(long filetime, boolean local) {
        return filetime / 10000L - 11644473600000L - (local ? (long)TZ_OFFSET : 0L);
    }

    public static String parseMmDdYyyyToYyyyMmDD(String dateString) {
        try {
            return String.format("%s-%s-%s", dateString.substring(6, 10), dateString.substring(0, 2), dateString.substring(3, 5));
        }
        catch (StringIndexOutOfBoundsException e) {
            return dateString;
        }
    }

    public static OffsetDateTime parseCimDateTimeToOffset(String cimDateTime) {
        try {
            int tzInMinutes = Integer.parseInt(cimDateTime.substring(22));
            LocalTime offsetAsLocalTime = LocalTime.MIDNIGHT.plusMinutes(tzInMinutes);
            return OffsetDateTime.parse(cimDateTime.substring(0, 22) + offsetAsLocalTime.format(DateTimeFormatter.ISO_LOCAL_TIME), CIM_FORMAT);
        }
        catch (IndexOutOfBoundsException | NumberFormatException | DateTimeParseException e) {
            Logger.trace("Unable to parse {} to CIM DateTime.", cimDateTime);
            return UNIX_EPOCH;
        }
    }

    public static void sleep(long ms) {
        try {
            Logger.trace("Sleeping for {} ms", ms);
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Logger.warn("Interrupted while sleeping for {} ms: {}", ms, e);
            Thread.currentThread().interrupt();
        }
    }

    public static boolean wildcardMatch(String text, String pattern) {
        if (pattern.length() > 0 && pattern.charAt(0) == '^') {
            return !Builder.wildcardMatch(text, pattern.substring(1));
        }
        return text.matches(pattern.replace("?", ".?").replace("*", ".*?"));
    }

    public static String getManufacturerID(byte[] edid) {
        String temp = String.format("%8s%8s", Integer.toBinaryString(edid[8] & 0xFF), Integer.toBinaryString(edid[9] & 0xFF)).replace(' ', '0');
        Logger.debug("Manufacurer ID: {}", temp);
        return String.format("%s%s%s", Character.valueOf((char)(64 + Integer.parseInt(temp.substring(1, 6), 2))), Character.valueOf((char)(64 + Integer.parseInt(temp.substring(7, 11), 2))), Character.valueOf((char)(64 + Integer.parseInt(temp.substring(12, 16), 2)))).replace("@", "");
    }

    public static String getProductID(byte[] edid) {
        return Integer.toHexString(ByteBuffer.wrap(Arrays.copyOfRange(edid, 10, 12)).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFF);
    }

    public static String getSerialNo(byte[] edid) {
        Logger.debug("Serial number: {}", Arrays.toString(Arrays.copyOfRange(edid, 12, 16)));
        return String.format("%s%s%s%s", Builder.getAlphaNumericOrHex(edid[15]), Builder.getAlphaNumericOrHex(edid[14]), Builder.getAlphaNumericOrHex(edid[13]), Builder.getAlphaNumericOrHex(edid[12]));
    }

    private static String getAlphaNumericOrHex(byte b) {
        return Character.isLetterOrDigit((char)b) ? String.format("%s", Character.valueOf((char)b)) : String.format("%02X", b);
    }

    public static byte getWeek(byte[] edid) {
        return edid[16];
    }

    public static int getYear(byte[] edid) {
        byte temp = edid[17];
        Logger.debug("Year-1990: {}", temp);
        return temp + 1990;
    }

    public static String getVersion(byte[] edid) {
        return edid[18] + "." + edid[19];
    }

    public static boolean isDigital(byte[] edid) {
        return 1 == (edid[20] & 0xFF) >> 7;
    }

    public static int getHcm(byte[] edid) {
        return edid[21];
    }

    public static int getVcm(byte[] edid) {
        return edid[22];
    }

    public static byte[][] getDescriptors(byte[] edid) {
        byte[][] desc = new byte[4][18];
        for (int i = 0; i < desc.length; ++i) {
            System.arraycopy(edid, 54 + 18 * i, desc[i], 0, 18);
        }
        return desc;
    }

    public static int getDescriptorType(byte[] desc) {
        return ByteBuffer.wrap(Arrays.copyOfRange(desc, 0, 4)).getInt();
    }

    public static String getTimingDescriptor(byte[] desc) {
        int clock = ByteBuffer.wrap(Arrays.copyOfRange(desc, 0, 2)).order(ByteOrder.LITTLE_ENDIAN).getShort() / 100;
        int hActive = (desc[2] & 0xFF) + ((desc[4] & 0xF0) << 4);
        int vActive = (desc[5] & 0xFF) + ((desc[7] & 0xF0) << 4);
        return String.format("Clock %dMHz, Active Pixels %dx%d ", clock, hActive, vActive);
    }

    public static String getDescriptorRangeLimits(byte[] desc) {
        return String.format("Field Rate %d-%d Hz vertical, %d-%d Hz horizontal, Max clock: %d MHz", desc[5], desc[6], desc[7], desc[8], desc[9] * 10);
    }

    public static String getDescriptorText(byte[] desc) {
        return new String(Arrays.copyOfRange(desc, 4, 18), StandardCharsets.US_ASCII).trim();
    }

    public static String toString(byte[] edid) {
        byte[][] desc;
        StringBuilder sb = new StringBuilder();
        sb.append("  Manuf. ID=").append(Builder.getManufacturerID(edid));
        sb.append(", Product ID=").append(Builder.getProductID(edid));
        sb.append(", ").append(Builder.isDigital(edid) ? "Digital" : "Analog");
        sb.append(", Serial=").append(Builder.getSerialNo(edid));
        sb.append(", ManufDate=").append(Builder.getWeek(edid) * 12 / 52 + 1).append('/').append(Builder.getYear(edid));
        sb.append(", EDID v").append(Builder.getVersion(edid));
        int hSize = Builder.getHcm(edid);
        int vSize = Builder.getVcm(edid);
        sb.append(String.format("%n  %d x %d cm (%.1f x %.1f in)", hSize, vSize, (double)hSize / 2.54, (double)vSize / 2.54));
        block8: for (byte[] b : desc = Builder.getDescriptors(edid)) {
            switch (Builder.getDescriptorType(b)) {
                case 255: {
                    sb.append("\n  Serial Number: ").append(Builder.getDescriptorText(b));
                    continue block8;
                }
                case 254: {
                    sb.append("\n  Unspecified Text: ").append(Builder.getDescriptorText(b));
                    continue block8;
                }
                case 253: {
                    sb.append("\n  Range Limits: ").append(Builder.getDescriptorRangeLimits(b));
                    continue block8;
                }
                case 252: {
                    sb.append("\n  Monitor Name: ").append(Builder.getDescriptorText(b));
                    continue block8;
                }
                case 251: {
                    sb.append("\n  White Point Data: ").append(Builder.byteArrayToHexString(b));
                    continue block8;
                }
                case 250: {
                    sb.append("\n  Standard Timing ID: ").append(Builder.byteArrayToHexString(b));
                    continue block8;
                }
                default: {
                    if (Builder.getDescriptorType(b) <= 15 && Builder.getDescriptorType(b) >= 0) {
                        sb.append("\n  Manufacturer Data: ").append(Builder.byteArrayToHexString(b));
                        continue block8;
                    }
                    sb.append("\n  Preferred Timing: ").append(Builder.getTimingDescriptor(b));
                }
            }
        }
        return sb.toString();
    }

    public static List<String> readFile(String filename) {
        return Builder.readFile(filename, true);
    }

    public static List<String> readFile(String filename, boolean reportError) {
        if (new File(filename).canRead()) {
            Logger.debug("Reading file {}", filename);
            try {
                return Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                if (reportError) {
                    Logger.error("Error reading file {}. {}", filename, e);
                }
            }
        } else if (reportError) {
            Logger.warn("File not found or not readable: {}", filename);
        }
        return new ArrayList<String>();
    }

    public static long getLongFromFile(String filename) {
        Logger.debug("Reading file {}", filename);
        List<String> read = Builder.readFile(filename, false);
        if (!read.isEmpty()) {
            Logger.trace("Read {}", read.get(0));
            return Builder.parseLongOrDefault(read.get(0), 0L);
        }
        return 0L;
    }

    public static long getUnsignedLongFromFile(String filename) {
        Logger.debug("Reading file {}", filename);
        List<String> read = Builder.readFile(filename, false);
        if (!read.isEmpty()) {
            Logger.trace("Read {}", read.get(0));
            return Builder.parseUnsignedLongOrDefault(read.get(0), 0L);
        }
        return 0L;
    }

    public static int getIntFromFile(String filename) {
        Logger.debug("Reading file {}", filename);
        try {
            List<String> read = Builder.readFile(filename, false);
            if (!read.isEmpty()) {
                Logger.trace("Read {}", read.get(0));
                return Integer.parseInt(read.get(0));
            }
        }
        catch (NumberFormatException ex) {
            Logger.warn("Unable to read value from {}. {}", filename, ex);
        }
        return 0;
    }

    public static String getStringFromFile(String filename) {
        Logger.debug("Reading file {}", filename);
        List<String> read = Builder.readFile(filename, false);
        if (!read.isEmpty()) {
            Logger.trace("Read {}", read.get(0));
            return read.get(0);
        }
        return "";
    }

    public static Map<String, String> getKeyValueMapFromFile(String filename, String separator) {
        HashMap<String, String> map = new HashMap<String, String>();
        Logger.debug("Reading file {}", filename);
        List<String> lines = Builder.readFile(filename, false);
        for (String line : lines) {
            String[] parts = line.split(separator);
            if (parts.length != 2) continue;
            map.put(parts[0], parts[1].trim());
        }
        return map;
    }

    static {
        TZ_OFFSET = TimeZone.getDefault().getOffset(System.currentTimeMillis());
        POWERS_OF_TEN = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        CIM_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSSSSSZZZZZ", Locale.US);
        multipliers = new HashMap<String, Long>();
        multipliers.put(HZ, 1L);
        multipliers.put(KHZ, 1000L);
        multipliers.put(MHZ, 1000000L);
        multipliers.put(GHZ, 1000000000L);
        multipliers.put(THZ, 1000000000000L);
        multipliers.put(PHZ, 1000000000000000L);
    }
}

