/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.Awaits;
import org.aoju.bus.core.io.Timeout;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.accord.ConnectInterceptor;
import org.aoju.bus.http.accord.StreamAllocation;
import org.aoju.bus.http.accord.platform.Platform;
import org.aoju.bus.http.cache.CacheInterceptor;
import org.aoju.bus.http.metric.EventListener;
import org.aoju.bus.http.metric.Interceptor;
import org.aoju.bus.http.metric.NamedRunnable;
import org.aoju.bus.http.metric.http.BridgeInterceptor;
import org.aoju.bus.http.metric.http.CallServerInterceptor;
import org.aoju.bus.http.metric.http.RealInterceptorChain;
import org.aoju.bus.http.metric.http.RetryAndFollowUp;
import org.aoju.bus.logger.Logger;

public final class RealCall
implements NewCall {
    public final Request originalRequest;
    public final boolean forWebSocket;
    final Httpd client;
    final RetryAndFollowUp retryAndFollowUp;
    final Awaits timeout;
    private EventListener eventListener;
    private boolean executed;

    private RealCall(Httpd client, Request originalRequest, boolean forWebSocket) {
        this.client = client;
        this.originalRequest = originalRequest;
        this.forWebSocket = forWebSocket;
        this.retryAndFollowUp = new RetryAndFollowUp(client, forWebSocket);
        this.timeout = new Awaits(){

            @Override
            protected void timedOut() {
                RealCall.this.cancel();
            }
        };
        this.timeout.timeout(client.callTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    static RealCall newRealCall(Httpd client, Request originalRequest, boolean forWebSocket) {
        RealCall call = new RealCall(client, originalRequest, forWebSocket);
        call.eventListener = client.eventListenerFactory().create(call);
        return call;
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute() throws IOException {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.captureCallStackTrace();
        this.timeout.enter();
        this.eventListener.callStart(this);
        try {
            this.client.dispatcher().executed(this);
            Response result = this.getResponseWithInterceptorChain();
            if (result == null) {
                throw new IOException("Canceled");
            }
            Response response = result;
            return response;
        }
        catch (IOException e) {
            e = this.timeoutExit(e);
            this.eventListener.callFailed(this, e);
            throw e;
        }
        finally {
            this.client.dispatcher().finished(this);
        }
    }

    IOException timeoutExit(IOException cause) {
        if (!this.timeout.exit()) {
            return cause;
        }
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    private void captureCallStackTrace() {
        Object callStackTrace = Platform.get().getStackTraceForCloseable("response.body().close()");
        this.retryAndFollowUp.setCallStackTrace(callStackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Callback responseCallback) {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.captureCallStackTrace();
        this.eventListener.callStart(this);
        this.client.dispatcher().enqueue(new AsyncCall(responseCallback));
    }

    @Override
    public void cancel() {
        this.retryAndFollowUp.cancel();
    }

    @Override
    public Timeout timeout() {
        return this.timeout;
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isCanceled() {
        return this.retryAndFollowUp.isCanceled();
    }

    @Override
    public RealCall clone() {
        return RealCall.newRealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    StreamAllocation streamAllocation() {
        return this.retryAndFollowUp.streamAllocation();
    }

    String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl();
    }

    String redactedUrl() {
        return this.originalRequest.url().redact();
    }

    Response getResponseWithInterceptorChain() throws IOException {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        interceptors.addAll(this.client.interceptors());
        interceptors.add(this.retryAndFollowUp);
        interceptors.add(new BridgeInterceptor(this.client.cookieJar()));
        interceptors.add(new CacheInterceptor(this.client.internalCache()));
        interceptors.add(new ConnectInterceptor(this.client));
        if (!this.forWebSocket) {
            interceptors.addAll(this.client.networkInterceptors());
        }
        interceptors.add(new CallServerInterceptor(this.forWebSocket));
        RealInterceptorChain chain = new RealInterceptorChain(interceptors, null, null, null, 0, this.originalRequest, this, this.eventListener, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        Response response = chain.proceed(this.originalRequest);
        if (this.retryAndFollowUp.isCanceled()) {
            IoUtils.close(response);
            throw new IOException("Canceled");
        }
        return response;
    }

    public final class AsyncCall
    extends NamedRunnable {
        private final Callback responseCallback;

        AsyncCall(Callback responseCallback) {
            super("Httpd %s", RealCall.this.redactedUrl());
            this.responseCallback = responseCallback;
        }

        public String host() {
            return RealCall.this.originalRequest.url().host();
        }

        Request request() {
            return RealCall.this.originalRequest;
        }

        public RealCall get() {
            return RealCall.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeOn(ExecutorService executorService) {
            assert (!Thread.holdsLock(RealCall.this.client.dispatcher()));
            boolean success = false;
            try {
                executorService.execute(this);
                success = true;
            }
            catch (RejectedExecutionException e) {
                InterruptedIOException ioException = new InterruptedIOException("executor rejected");
                ioException.initCause(e);
                RealCall.this.eventListener.callFailed(RealCall.this, ioException);
                this.responseCallback.onFailure(RealCall.this, ioException);
            }
            finally {
                if (!success) {
                    RealCall.this.client.dispatcher().finished(this);
                }
            }
        }

        @Override
        protected void execute() {
            boolean signalledCallback = false;
            RealCall.this.timeout.enter();
            try {
                Response response = RealCall.this.getResponseWithInterceptorChain();
                signalledCallback = true;
                this.responseCallback.onResponse(RealCall.this, response);
            }
            catch (IOException e) {
                e = RealCall.this.timeoutExit(e);
                if (signalledCallback) {
                    Logger.info("Callback failure for " + RealCall.this.toLoggableString(), e);
                } else {
                    RealCall.this.eventListener.callFailed(RealCall.this, e);
                    this.responseCallback.onFailure(RealCall.this, e);
                }
            }
            catch (Throwable t) {
                RealCall.this.cancel();
                if (!signalledCallback) {
                    IOException canceledException = new IOException("canceled due to " + t);
                    this.responseCallback.onFailure(RealCall.this, canceledException);
                }
                throw t;
            }
            finally {
                RealCall.this.client.dispatcher().finished(this);
            }
        }
    }
}

